% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_DotPlot.R
\name{do_DotPlot}
\alias{do_DotPlot}
\title{This function is a wrapper for \link[Seurat]{DotPlot}. It provides most of its functionalities while adding extra.
You can}
\usage{
do_DotPlot(
  sample,
  features,
  assay = NULL,
  slot = "data",
  group.by = NULL,
  split.by = NULL,
  zscore.data = FALSE,
  min.cutoff = NA,
  max.cutoff = NA,
  dot.min = 5,
  enforce_symmetry = ifelse(base::isTRUE(zscore.data), TRUE, FALSE),
  legend.title = NULL,
  legend.type = "colorbar",
  legend.position = "bottom",
  legend.framewidth = 0.5,
  legend.tickwidth = 0.5,
  legend.length = 20,
  legend.width = 1,
  legend.framecolor = "grey50",
  legend.tickcolor = "white",
  legend.ncol = NULL,
  legend.nrow = NULL,
  legend.byrow = FALSE,
  dot.scale = 8,
  plot.title = NULL,
  plot.subtitle = NULL,
  plot.caption = NULL,
  xlab = NULL,
  ylab = NULL,
  font.size = 14,
  font.type = "sans",
  cluster.identities = FALSE,
  cluster.features = FALSE,
  flip = FALSE,
  axis.text.x.angle = 45,
  use_viridis = FALSE,
  viridis.palette = "G",
  viridis.direction = -1,
  sequential.palette = "YlGnBu",
  sequential.direction = 1,
  diverging.palette = "RdBu",
  diverging.direction = -1,
  na.value = "grey75",
  plot.grid = TRUE,
  grid.color = "grey75",
  grid.type = "dashed",
  number.breaks = 5,
  plot.title.face = "bold",
  plot.subtitle.face = "plain",
  plot.caption.face = "italic",
  axis.title.face = "bold",
  axis.text.face = "plain",
  legend.title.face = "bold",
  legend.text.face = "plain"
)
}
\arguments{
\item{sample}{\strong{\code{\link[SeuratObject]{Seurat}}} | A Seurat object, generated by \link[Seurat]{CreateSeuratObject}.}

\item{features}{\strong{\code{\link[base]{character}}} | Features to represent.}

\item{assay}{\strong{\code{\link[base]{character}}} | Assay to use. Defaults to the current assay.}

\item{slot}{\strong{\code{\link[base]{character}}} | Data slot to use. Only one of: counts, data, scale.data. Defaults to "data".}

\item{group.by}{\strong{\code{\link[base]{character}}} | Metadata variable to group the output by. Has to be a character of factor column.}

\item{split.by}{\strong{\code{\link[base]{character}}} | Secondary metadata variable to further group (split) the output by. Has to be a character of factor column.}

\item{zscore.data}{\strong{\code{\link[base]{logical}}} | Whether to compute Z-scores instead of showing average expression values. This allows to see, for each gene, which group has the highest average expression, but prevents you from comparing values across genes. Can not be used with slot = "scale.data" or with split.by.}

\item{min.cutoff, max.cutoff}{\strong{\code{\link[base]{numeric}}} | Set the min/max ends of the color scale. Any cell/group with a value lower than min.cutoff will turn into min.cutoff and any cell with a value higher than max.cutoff will turn into max.cutoff. In FeaturePlots, provide as many values as features. Use NAs to skip a feature.}

\item{dot.min}{\strong{\code{\link[base]{numeric}}} | Ranges from 0 to 100. Filter out dots whose Percent Expressed falls below this threshold.}

\item{enforce_symmetry}{\strong{\code{\link[base]{logical}}} | Return a symmetrical plot axes-wise or continuous color scale-wise, when applicable.}

\item{legend.title}{\strong{\code{\link[base]{character}}} | Title for the legend.}

\item{legend.type}{\strong{\code{\link[base]{character}}} | Type of legend to display. One of:
\itemize{
\item \emph{\code{normal}}: Default legend displayed by \pkg{ggplot2}.
\item \emph{\code{colorbar}}: Redefined colorbar legend, using \link[ggplot2]{guide_colorbar}.
}}

\item{legend.position}{\strong{\code{\link[base]{character}}} | Position of the legend in the plot. One of:
\itemize{
\item \emph{\code{top}}: Top of the figure.
\item \emph{\code{bottom}}: Bottom of the figure.
\item \emph{\code{left}}: Left of the figure.
\item \emph{\code{right}}: Right of the figure.
\item \emph{\code{none}}: No legend is displayed.
}}

\item{legend.framewidth, legend.tickwidth}{\strong{\code{\link[base]{numeric}}} | Width of the lines of the box in the legend.}

\item{legend.length, legend.width}{\strong{\code{\link[base]{numeric}}} | Length and width of the legend. Will adjust automatically depending on legend side.}

\item{legend.framecolor}{\strong{\code{\link[base]{character}}} | Color of the lines of the box in the legend.}

\item{legend.tickcolor}{\strong{\code{\link[base]{character}}} | Color of the ticks of the box in the legend.}

\item{legend.ncol}{\strong{\code{\link[base]{numeric}}} | Number of columns in the legend.}

\item{legend.nrow}{\strong{\code{\link[base]{numeric}}} | Number of rows in the legend.}

\item{legend.byrow}{\strong{\code{\link[base]{logical}}} | Whether the legend is filled by row or not.}

\item{dot.scale}{\strong{\code{\link[base]{numeric}}} | Scale the size of the dots.}

\item{plot.title, plot.subtitle, plot.caption}{\strong{\code{\link[base]{character}}} | Title, subtitle or caption to use in the plot.}

\item{xlab, ylab}{\strong{\code{\link[base]{character}}} | Titles for the X and Y axis.}

\item{font.size}{\strong{\code{\link[base]{numeric}}} | Overall font size of the plot. All plot elements will have a size relationship with this font size.}

\item{font.type}{\strong{\code{\link[base]{character}}} | Base font family for the plot. One of:
\itemize{
\item \emph{\code{mono}}: Mono spaced font.
\item \emph{\code{serif}}: Serif font family.
\item \emph{\code{sans}}: Default font family.
}}

\item{cluster.identities}{\strong{\code{\link[base]{logical}}} | Whether to cluster the identities (groups) based on the expression of the features.}

\item{cluster.features}{\strong{\code{\link[base]{logical}}} | Whether to cluster the features (genes) based on their expression across identities.}

\item{flip}{\strong{\code{\link[base]{logical}}} | Whether to invert the axis of the displayed plot.}

\item{axis.text.x.angle}{\strong{\code{\link[base]{numeric}}} | Degree to rotate the X labels. One of: 0, 45, 90.}

\item{use_viridis}{\strong{\code{\link[base]{logical}}} | Whether to use viridis color scales.}

\item{viridis.palette}{\strong{\code{\link[base]{character}}} | A capital letter from A to H or the scale name as in \link[viridis]{scale_fill_viridis}.}

\item{viridis.direction}{\strong{\code{\link[base]{numeric}}} | Either 1 or -1. Controls how the gradient of viridis scale is formed.}

\item{sequential.palette}{\strong{\code{\link[base]{character}}} | Type of sequential color palette to use. Out of the sequential palettes defined in \strong{\code{\link[RColorBrewer]{brewer.pal}}}.}

\item{sequential.direction}{\strong{\code{\link[base]{numeric}}} | Direction of the sequential color scale. Either 1 or -1.}

\item{diverging.palette}{\strong{\code{\link[base]{character}}} | Type of symmetrical color palette to use. Out of the diverging palettes defined in \strong{\code{\link[RColorBrewer]{brewer.pal}}}.}

\item{diverging.direction}{\strong{\code{\link[base]{numeric}}} | Either 1 or -1. Direction of the divering palette. This basically flips the two ends.}

\item{na.value}{\strong{\code{\link[base]{character}}} | Color value for NA.}

\item{plot.grid}{\strong{\code{\link[base]{logical}}} | Whether to plot grid lines.}

\item{grid.color}{\strong{\code{\link[base]{character}}} | Color of the grid in the plot. In heatmaps, color of the border of the cells.}

\item{grid.type}{\strong{\code{\link[base]{character}}} | One of the possible linetype options:
\itemize{
\item \emph{\code{blank}}.
\item \emph{\code{solid}}.
\item \emph{\code{dashed}}.
\item \emph{\code{dotted}}.
\item \emph{\code{dotdash}}.
\item \emph{\code{longdash}}.
\item \emph{\code{twodash}}.
}}

\item{number.breaks}{\strong{\code{\link[base]{numeric}}} | Controls the number of breaks in continuous color scales of ggplot2-based plots.}

\item{plot.title.face, plot.subtitle.face, plot.caption.face, axis.title.face, axis.text.face, legend.title.face, legend.text.face}{\strong{\code{\link[base]{character}}} | Controls the style of the font for the corresponding theme element.  One of:
\itemize{
\item \emph{\code{plain}}: For normal text.
\item \emph{\code{italic}}: For text in itallic.
\item \emph{\code{bold}}: For text in bold.
\item \emph{\code{bold.italic}}: For text both in itallic and bold.
}}
}
\value{
A ggplot2 object containing a Dot Plot.
}
\description{
This function is a wrapper for \link[Seurat]{DotPlot}. It provides most of its functionalities while adding extra.
You can
}
\examples{
\donttest{
  # Check Suggests.
  value <- SCpubr:::check_suggests(function_name = "do_DotPlot", passive = TRUE)

  if (isTRUE(value)){
    # Consult the full documentation in https://enblacar.github.io/SCpubr-book/
    
    # Define your Seurat object.
    # sample <- readRDS(system.file("extdata/seurat_dataset_example.rds", package = "SCpubr"))

    # Basic Dot plot.
    # genes <- rownames(sample)[1:14]
    # p <- SCpubr::do_DotPlot(sample = sample,
    #                        features = genes)

  } else if (base::isFALSE(value)){
    message("This function can not be used without its suggested packages.")
    message("Check out which ones are needed using `SCpubr::state_dependencies()`.")
  }
}
}
