% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRMed2.R
\name{LRMed2}
\alias{LRMed2}
\title{Calculate the CDE, NDE and NIE (linear models, continuous exposure).}
\usage{
LRMed2(
  data,
  exposure,
  mediator,
  outcome,
  confounderVec,
  mValue,
  eValueLow,
  eValueHigh
)
}
\arguments{
\item{data}{A data frame.}

\item{exposure}{The name of the exposure (must be a continuous variable).}

\item{mediator}{The name of the mediator (must be a continuous variable).}

\item{outcome}{The name of the outcome (must be a continuous variable).}

\item{confounderVec}{The name vector of the confounders.}

\item{mValue}{The controlled mediator value for CDE estimation.}

\item{eValueLow}{The low reference level of exposure.}

\item{eValueHigh}{The high reference level of exposure.}
}
\value{
A list of exposure-outcome model, exposure-mediator model, CDE, NDE and NIE and their asymptotic variances.
}
\description{
Calculate the CDE, NDE and NIE (linear models, continuous exposure).
}
\examples{
medModel <- LRMed2(data = data.sim.med,
                   exposure = "pesticideCont", mediator = "hormone", outcome = "ySim",
                   confounderVec = c("age", "invwt", "race2", "race3", "race4", "race5",
                                     "season2", "season3", "season4", "smoking1", "ovum1",
                                     "diabetes1"),
                   mValue = 0.15, eValueLow = 0.1, eValueHigh = 1.1)
medModel
}
