% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Export.R
\name{exportToCsv}
\alias{exportToCsv}
\title{Export SCCSresults to CSV files}
\usage{
exportToCsv(
  outputFolder,
  exportFolder = file.path(outputFolder, "export"),
  databaseId = 1,
  minCellCount = 5,
  maxCores = 1
)
}
\arguments{
\item{outputFolder}{The folder where runCmAnalyses() generated all results.}

\item{exportFolder}{The folder where the CSV files will written.}

\item{databaseId}{A unique ID for the database. This will be appended to
most tables.}

\item{minCellCount}{To preserve privacy: the minimum number of subjects contributing
to a count before it can be included in the results. If the
count is below this threshold, it will be set to \code{-minCellCount}.}

\item{maxCores}{Maximum number of CPU cores to use.}
}
\value{
Does not return anything. Is called for the side-effect of populating the \code{exportFolder}
with CSV files.
}
\description{
Export SCCSresults to CSV files
}
\details{
This requires that \code{\link[=runSccsAnalyses]{runSccsAnalyses()}} has been executed first. It exports
all the results in the \code{outputFolder} to CSV files for sharing with other
sites.
}
