% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm2d.R
\name{norm2d}
\alias{norm2d}
\title{Bivariate normal density with independent components}
\usage{
norm2d(x, y, mu = c(0, 0), sd = c(1, 1), log = FALSE)
}
\arguments{
\item{x}{Numeric vector of x-coordinate(s).}

\item{y}{Numeric vector of y-coordinate(s).}

\item{mu}{Numeric vector of length 2 giving \code{c(mu_x, mu_y)}.}

\item{sd}{Numeric vector of length 2 giving positive standard deviations \code{c(sd_x, sd_y)}.}

\item{log}{Logical; if \code{TRUE}, return the log-density.}
}
\value{
Numeric vector of densities (or log-densities) with length determined by standard
recycling rules for \code{x} and \code{y}.
}
\description{
Evaluates the density of a bivariate normal distribution with mean vector
\eqn{\mu = (\mu_x,\mu_y)} and diagonal covariance matrix (independent components).
The density is the product of the two univariate normal densities:
\deqn{f(x,y) = \phi(x;\mu_x,\sigma_x)\,\phi(y;\mu_y,\sigma_y).}
}
\examples{

# Evaluate the density at the peak
norm2d(0.5, 0.5, mu = c(0.5, 0.5), sd = c(0.2, 0.2))

# Evaluate at multiple x values
norm2d(c(0.3, 0.7), 0.5, mu = c(0.5, 0.5), sd = c(0.2, 0.2))

# Visualize on a grid
x <- y <- seq(0, 1, length.out = 100)
f <- Vectorize(function(x, y) norm2d(x, y, mu = c(0.5, 0.5), sd = c(0.2, 0.2)))
z <- outer(x, y, f)
image(x, y, z, col = terrain.colors(50), main = "Bivariate Normal Intensity")
contour(x, y, z, add = TRUE)

}
\author{
Mohammad Ghorbani \email{mohammad.ghorbani@slu.se}\cr
Nafiseh Vafaei \email{nafiseh.vafaei@slu.se}
}
