% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_data}
\alias{get_data}
\title{Load Data Files of Various Formats}
\usage{
get_data(dir, file_names = NULL)
}
\arguments{
\item{dir}{Character. Path to the directory containing data files.}

\item{file_names}{Character vector. Optional base names (with or without extensions)
to load; if \code{NULL}, loads all supported files from the directory.}
}
\value{
If exactly one file is loaded, returns the dataset.
If multiple files are loaded, returns a named list of datasets.
}
\description{
Loads one or more data files from a given directory.
Supports multiple file types commonly used in clinical trials:
\code{.sas7bdat}, \code{.xpt}, \code{.csv}, \code{.xls}, and \code{.xlsx}.
}
\details{
Automatically detects file extensions and returns each dataset using its
base file name (e.g., \code{"adsl.xpt"} becomes \code{adsl}).

If multiple files with the same base name but different extensions exist
(e.g., \code{adsl.csv} and \code{adsl.sas7bdat}), the function stops and reports the
duplicates to avoid ambiguity.
}
\examples{
\dontrun{

adsl <- get_data("path/to/adam", "adsl")

ds <- get_data("path/to/adam")

adsl <- ds$adsl

}

}
