% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_by.R
\name{mean_by}
\alias{mean_by}
\title{Summary Table: Mean and Related Statistics by Group}
\usage{
mean_by(
  data,
  group_var,
  uniq_var,
  label,
  sec_ord,
  precision_override = NULL,
  indent = 3,
  use_sas_round = FALSE,
  id_var = "USUBJID"
)
}
\arguments{
\item{data}{A data frame or tibble containing the input data.}

\item{group_var}{The grouping variable (e.g., treatment arm).
Can be unquoted (tidy evaluation) or a string.}

\item{uniq_var}{The numeric variable to summarise.
Can be unquoted (tidy evaluation) or a string.}

\item{label}{Character string: table section label for the output (e.g., \code{"BMI (WEIGHT [KG]/ HEIGHT [M2])"}).}

\item{sec_ord}{Integer: section order value (for downstream table ordering).}

\item{precision_override}{Optional integer to manually set decimal precision; if \code{NULL}, the function infers precision from the data.}

\item{indent}{Integer: number of leading spaces in statistic labels (default = 3).}

\item{use_sas_round}{Logical: if \code{TRUE}, applies SAS-compatible rounding (round half away from zero). Default is \code{FALSE}.}

\item{id_var}{Character: name of subject ID variable (default = \code{"USUBJID"}).
If not found, function attempts to auto-detect common ID variable names.}
}
\value{
A tibble with the following columns:
\itemize{
\item \code{stats} : internal statistic code (\code{n1}, \code{mn}, \code{sd}, etc.)
\item \code{stat}  : display label (\code{"   N"}, \code{"   MEAN"}, etc.)
\item \code{sort_ord} : row ordering number
\item \code{sec_ord} : section ordering number (from input)
\item Treatment columns (\code{trt1}, \code{trt2}, ...): formatted values per treatment group
}
}
\description{
This function calculates common summary statistics (N, Mean, SD, Median, Q1, Q3, Min, Max) for a
numeric variable, grouped by a treatment or category variable.
It supports optional \strong{SAS-style rounding} (round half away from zero) and formats the results
for table-ready display.
Missing treatment groups are automatically added with zero values.
}
\details{
The function:
\enumerate{
\item Auto-detects precision if \code{precision_override} is \code{NULL}.
\item Calculates N, mean, SD, quartiles, min, max.
\item Applies SAS-style rounding if \code{use_sas_round = TRUE}.
\item Converts statistics into a display format suitable for RTF or text output.
\item Ensures all treatment columns appear in output, filling missing ones with \code{"0"}.
}

\strong{SAS-style rounding logic:}
Values exactly halfway between two increments are rounded away from zero
(e.g., \code{1.25} → \code{1.3}, \code{-1.25} → \code{-1.3} with 1 decimal place).
}
\examples{
library(dplyr)

df <- tibble::tibble(
  USUBJID = rep(1:6, each = 1),
  TRTAN   = c(1, 1, 2, 2, 3, 3),
  BMIBL   = c(25.1, 26.3, 24.8, NA, 23.4, 27.6)
)
mean_by(
  data          = df,
  group_var     = TRTAN,
  uniq_var      = BMIBL,
  label         = "BMI (kg/m^2)",
  sec_ord       = 1
)


mean_by(
  data          = df,
  group_var     = TRTAN,
  uniq_var      = BMIBL,
  label         = "BMI (kg/m^2)",
  sec_ord       = 1,
  precision_override = 2
)


mean_by(
  data          = df,
  group_var     = TRTAN,
  uniq_var      = BMIBL,
  label         = "BMI (kg/m^2)",
  sec_ord       = 1,
  use_sas_round = TRUE
)


df2 <- tibble::tibble(
  USUBJID = c(1, 2, 3, 4),
  TRTAN   = c(1, 1, 3, 3),
  BMIBL   = c(25.1, 26.3, 23.4, 27.6)
)

mean_by(
  data      = df2,
  group_var = TRTAN,
  uniq_var  = BMIBL,
  label     = "BMI (kg/m^2)",
  sec_ord   = 1
)

}
