% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeostTextureLibrarySharedRoxy.R
\name{RRIK3}
\alias{RRIK3}
\alias{RRIK3.numeric}
\alias{RRIK3.SpatRaster}
\title{RRIK3: Radial Roughness index with differences of order 3}
\usage{
RRIK3(x, ...)

\method{RRIK3}{numeric}(x, ...)

\method{RRIK3}{SpatRaster}(x, ..., .method = c("rcpp", "r"))
}
\arguments{
\item{x}{A DEM/image as a SpatRaster or a vector of numeric values from a focal window in a DEM from which to compute the index}

\item{...}{reserved for future use}

\item{.method}{Either \code{r} or \code{rcpp} (fast batch processing using C++, still to implement)}
}
\value{
isotropic roughness (in the same units of input)
}
\description{
Extension of RRI using differences of order 3, with a 5x5 kernel.
Accordingly, this version filters out a trend of order 2, so it reduces still more the dependence
on slope and partially on curvature (for filtering of curvature better to select RRIk4()).
The input is the DEM/image (no need to detrend).
}
\examples{
library(terra)
dem= rast(paste(system.file("extdata", package = "SurfRough"), "/trento1.tif",sep=""))
roughRRIK3=RRIK3(dem)
plot(roughRRIK3)
}
\references{
Trevisani S., Teza G., Guth P.L., 2023. Hacking the topographic ruggedness index. Geomorphology,
\doi{doi:10.1016/j.geomorph.2023.108838}.
}
