% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_logishp.R
\name{logisst}
\alias{logisst}
\alias{dlogisst}
\alias{plogisst}
\alias{qlogisst}
\alias{rlogisst}
\alias{dplogisst}
\alias{dqlogisst}
\alias{llogisst}
\alias{dllogisst}
\alias{qllogisst}
\alias{varlogisst}
\alias{ltmlogisst}
\alias{rtmlogisst}
\alias{eslogisst}
\title{The Standardized Logistic Distribution}
\usage{
dlogisst(x, m = 0, g = 1, log = FALSE)

plogisst(q, m = 0, g = 1, lower.tail = TRUE, log.p = FALSE)

qlogisst(p, m = 0, g = 1, lower.tail = TRUE, log.p = FALSE)

rlogisst(n, m = 0, g = 1)

dplogisst(p, m = 0, g = 1, log = FALSE)

dqlogisst(p, m = 0, g = 1, k = 3.2, log = FALSE)

llogisst(x, m = 0, g = 1)

dllogisst(lp, m = 0, g = 1, k = 3.2, log = FALSE)

qllogisst(lp, m = 0, g = 1, k = 3.2, lower.tail = TRUE)

varlogisst(p, m = 0, g = 1, k = 3.2, lower.tail = TRUE,
  log.p = FALSE)

ltmlogisst(p, m = 0, g = 1, lower.tail = TRUE, log.p = FALSE)

rtmlogisst(p, m = 0, g = 1, lower.tail = TRUE, log.p = FALSE)

eslogisst(p, m = 0, g = 1, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{x}{vector of quantiles.}

\item{m}{numeric. a central parameter (also used in model K1, K2, K3 and K4).}

\item{g}{numeric. a scale parameter (also used in model K1, K2, K3 and K4).}

\item{log}{boolean.}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical. If TRUE, use p. If FALSE, use 1-p.}

\item{log.p}{logical. If TRUE, probabilities p are given as log(p).}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If length(n) > 1, the length is 
taken to be the number required.}

\item{k}{numeric. The tail parameter, preferably strictly positive.
Can be a vector (see details).}

\item{lp}{vector of logit of probabilities.}
}
\description{
Density, distribution function, quantile function, random generation, 
value-at-risk, left-tail mean, right-tail mean, expected shortfall
for the standardized logistic distribution, equivalent to 
\code{dpqrlogis(..., scale = g*sqrt(3)/pi)}.
}
\details{
\code{dlogisst} function (log is available) is defined for 
                x in (-Inf, +Inf) by: 
  \deqn{ dlogisst(x, m, g) = 
        stats::dlogis(x, location = m, scale = g*sqrt(3)/pi) }
\code{plogisst} function is defined for q in (-Inf, +Inf) by: 
  \deqn{ plogisst(q, m, g) = 
         stats::plogis(q, location = m, scale = g*sqrt(3)/pi) }
\code{qlogisst} function is defined for p in (0, 1) by: 
   \deqn{ qlogisst(p, m, g) = 
          stats::qlogis(p, location = m, scale = g*sqrt(3)/pi) }
\code{rlogisst} function generates \code{n} random values.

In addition to the classical formats, the prefixes dp, dq, l, dl, ql 
are also provided:

\code{dplogisst} function (log is available) is defined for p in (0, 1) by: 
     \deqn{ dplogisst(p, m, g) =  p*(1-p)/g*pi/sqrt(3) + m*0 }
\code{dqlogisst} function (log is available) is defined for p in (0, 1) by: 
     \deqn{ dqlogisst(p, m, g) = 1/p/(1-p)*sqrt(3)/pi*g + m*0 }
\code{llogisst} function is defined for x in (-Inf, +Inf) by: 
     \deqn{ llogisst(x, m, g) = (x-m)/g*pi/sqrt(3) }
\code{dllogisst} function is defined for lp = logit(p) in (-Inf, +Inf) by : 
     \deqn{ dllogisst(lp, m, g) = p*(1-p)/g*pi/sqrt(3) }
\code{qllogisst} function is defined for lp = logit(p) in (-Inf, +Inf) by : 
     \deqn{ qllogisst(lp, m, g) = m + sqrt(3)/pi*g }

If k is a vector, then the use of the function \code{\link[base]{outer}} 
is recommanded.

Functions \code{eslogis} is the expected shortfall of the logistic function 
(times a factor 2). 
When \code{p<=0.5}, it is equivalent (times -1) to the left tail mean \code{ltmlogisst}. 
When \code{p>0.5}, it is equivalent to the right tail mean \code{rtmlogisst}. 
\code{ltmlogisst} and \code{rtmlogisst} are used to calculate the \code{h} parameter 
in \code{\link{hkiener1}}, \code{hkiener2}, \code{hkiener3}, \code{hkiener4}.
}
\seealso{
Kiener distribution K1 \code{\link{kiener1}} which has 
location (\code{m}) and scale (\code{g}) parameters.
}
