% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{linestrings_from_graph}
\alias{linestrings_from_graph}
\title{Convert Graph to Linestrings}
\usage{
linestrings_from_graph(graph_df, crs = 4326)
}
\arguments{
\item{graph_df}{A data frame representing a graph with columns:
\code{FX}, \code{FY}, \code{TX}, \code{TY} (starting and ending node coordinates),
and optionally other columns to preserve.}

\item{crs}{Numeric or character (default: 4326). Coordinate reference system
to assign to the output sf object.}
}
\value{
An sf data frame with LINESTRING geometry, containing all columns from
  \code{graph_df} except \code{FX}, \code{FY}, \code{TX}, and \code{TY}. Each row
  represents an edge as a LINESTRING connecting the from-node (\code{FX}, \code{FY})
  to the to-node (\code{TX}, \code{TY}).
}
\description{
Convert a graph data frame with node coordinates to an sf object with LINESTRING geometries.
}
\details{
This function is the inverse operation of \code{\link{linestrings_to_graph}}. It:
\itemize{
  \item Creates LINESTRING geometries from node coordinates (\code{FX}, \code{FY}, \code{TX}, \code{TY})
  \item Removes the coordinate columns from the output
  \item Preserves all other columns from the input graph data frame
  \item Returns an sf object suitable for spatial operations and visualization
}
}
\examples{
library(flownet)
library(sf)

# Convert segments data frame to sf LINESTRING object
segments_sf <- linestrings_from_graph(africa_segments)
class(segments_sf)
head(segments_sf)

\donttest{
# Plot segments colored by route importance
plot(segments_sf["passes"])
}

}
\seealso{
\link{linestrings_to_graph} \link{flownet-package}
}
