desc_curry_text <- "
<b>Description</b><br>
This simulated dataset, based on Curry et al. (2019), contains data on moral relevance and judgment across the seven domains of the Morality As Cooperation scale.
<br><br>

<b>Details</b><br>
<table border='0' cellpadding='4'>
<tr><td><b>sex</b> (factor): Self-identified sex of participants (Male, Female, or Transgendered).</td></tr>
<tr><td><b>age_years</b> (numeric): Participants' age in years.</td></tr>
<tr><td><b>KinshipR</b> (numeric): Mean score of moral relevance, kinship subscale.</td></tr>
<tr><td><b>MutualismR</b> (numeric): Mean score of moral relevance, mutualism subscale.</td></tr>
<tr><td><b>ExchangeR</b> (numeric): Mean score of moral relevance, exchange subscale.</td></tr>
<tr><td><b>HawkR</b> (numeric): Mean score of moral relevance, hawk subscale.</td></tr>
<tr><td><b>DoveR</b> (numeric): Mean score of moral relevance, dove subscale.</td></tr>
<tr><td><b>DivisionR</b> (numeric): Mean score of moral relevance, division subscale.</td></tr>
<tr><td><b>PossessionR</b> (numeric): Mean score of moral relevance, possession subscale.</td></tr>
<tr><td><b>KinshipJ</b> (numeric): Mean score of moral judgment, kinship subscale.</td></tr>
<tr><td><b>MutualismJ</b> (numeric): Mean score of moral judgment, mutualism subscale.</td></tr>
<tr><td><b>ExchangeJ</b> (numeric): Mean score of moral judgment, exchange subscale.</td></tr>
<tr><td><b>HawkJ</b> (numeric): Mean score of moral judgment, hawk subscale.</td></tr>
<tr><td><b>DoveJ</b> (numeric): Mean score of moral judgment, dove subscale.</td></tr>
<tr><td><b>DivisionJ</b> (numeric): Mean score of moral judgment, division subscale.</td></tr>
<tr><td><b>PossessionJ</b> (numeric): Mean score of moral judgment, possession subscale.</td></tr>
</table><br>

<b>Reference</b><br>
Curry, O. S., Jones Chesters, M., & Van Lissa, C. J. (2019). 
<i>Mapping morality with a compass: Testing the theory of 'morality-as-cooperation' with a new questionnaire.</i> 
<em>Journal of Research in Personality, 78</em>, 106–124. 
<a href='https://doi.org/10.1016/j.jrp.2018.10.008' target='_blank'>https://doi.org/10.1016/j.jrp.2018.10.008</a>
"


desc_pisa <- "
<b>Description</b><br>
Student questionnaire data with four variables from the 2015 PISA survey for students in the United States.<br><br>

<b>Details</b><br>
<table border='0' cellpadding='4'>
<tr><td><b>broad_interest</b> (numeric): Composite measure of students' self-reported broad interest.</td></tr>
<tr><td><b>enjoyment</b> (numeric): Composite measure of students' self-reported enjoyment.</td></tr>
<tr><td><b>instrumental_mot</b> (numeric): Composite measure of students' self-reported instrumental motivation.</td></tr>
<tr><td><b>self_efficacy</b> (numeric): Composite measure of students' self-reported self-efficacy.</td></tr>
</table><br>

<b>Source</b><br>
<a href='http://www.oecd.org/pisa/data/' target='_blank'>OECD PISA Data Portal</a>
"


desc_id_edu <- "
<b>Description</b><br>
This simulated dataset, based on <i>Crocetti et al., 2014</i>, contains five annual assessments of adolescents' mean scores on the commitment, exploration (in depth), and reconsideration subscales of the Utrecht-Management of Identity Commitments Scale (<i>Crocetti et al., 2008</i>). 
The scores reported here reflect the <b>educational identity</b> subscales of this instrument. 
The first measurement wave occurred when adolescents were, on average, 14 years old, and the last one when they were 18 years old.<br><br>

<b>Details</b><br>
<table border='0' cellpadding='4'>
<tr><td><b>com1</b> (numeric): Mean score of educational commitment in wave 1.</td></tr>
<tr><td><b>exp1</b> (numeric): Mean score of educational exploration in wave 1.</td></tr>
<tr><td><b>rec1</b> (numeric): Mean score of educational reconsideration in wave 1.</td></tr>
<tr><td><b>com2</b> (numeric): Mean score of educational commitment in wave 2.</td></tr>
<tr><td><b>exp2</b> (numeric): Mean score of educational exploration in wave 2.</td></tr>
<tr><td><b>rec2</b> (numeric): Mean score of educational reconsideration in wave 2.</td></tr>
<tr><td><b>com3</b> (numeric): Mean score of educational commitment in wave 3.</td></tr>
<tr><td><b>exp3</b> (numeric): Mean score of educational exploration in wave 3.</td></tr>
<tr><td><b>rec3</b> (numeric): Mean score of educational reconsideration in wave 3.</td></tr>
<tr><td><b>com4</b> (numeric): Mean score of educational commitment in wave 4.</td></tr>
<tr><td><b>exp4</b> (numeric): Mean score of educational exploration in wave 4.</td></tr>
<tr><td><b>rec4</b> (numeric): Mean score of educational reconsideration in wave 4.</td></tr>
<tr><td><b>com5</b> (numeric): Mean score of educational commitment in wave 5.</td></tr>
<tr><td><b>exp5</b> (numeric): Mean score of educational exploration in wave 5.</td></tr>
<tr><td><b>rec5</b> (numeric): Mean score of educational reconsideration in wave 5.</td></tr>
<tr><td><b>sex</b> (factor): Adolescent sex; M = male, F = female.</td></tr>
</table><br>

<b>References</b><br>
Crocetti, E., Klimstra, T. A., Hale, W. W., Koot, H. M., & Meeus, W. (2013). 
<a href='https://doi.org/10.1007/s10964-013-9924-6' target='_blank'>
<i>Impact of early adolescent externalizing problem behaviors on identity development in middle to late adolescence: A prospective 7-year longitudinal study.</i></a> 
<i>Journal of Youth and Adolescence, 42(11)</i>, 1745–1758.
"

desc_cheating <- "
<b>Description</b><br>
This dataset contains dichotomous responses from 319 undergraduate students regarding academic cheating behaviors, along with their academic grade point average (GPA). 
The data are commonly used to illustrate latent class analysis of categorical variables.<br><br>

<b>Details</b><br>
<table border='0' cellpadding='4'>
<tr><td><b>LIEEXAM</b> (numeric): Whether the student ever lied to avoid taking an exam (1 = no, 2 = yes).</td></tr>
<tr><td><b>LIEPAPER</b> (numeric): Whether the student ever lied to avoid submitting a term paper on time (1 = no, 2 = yes).</td></tr>
<tr><td><b>FRAUD</b> (numeric): Whether the student ever purchased a term paper or obtained an exam copy prior to taking it (1 = no, 2 = yes).</td></tr>
<tr><td><b>COPYEXAM</b> (numeric): Whether the student ever copied answers during an exam from another student (1 = no, 2 = yes).</td></tr>
<tr><td><b>GPA</b> (factor): Academic grade point average, categorized into five groups:
(1) ≤ 2.99; 
(2) 3.00–3.25; 
(3) 3.26–3.50; 
(4) 3.51–3.75; 
(5) 3.76–4.00.</td></tr>
</table><br>

<b>Notes</b><br>
GPA data were not available for four students who reported never engaging in any cheating behavior.<br><br>

<b>Source</b><br>
Dayton, C. M. (1998). 
<i>Latent Class Scaling Analysis.</i> 
Thousand Oaks, CA: SAGE Publications.
"


desc_lazar <- "
<b>Description</b><br>
This dataset is a classical example introduced by Lazarsfeld and Henry (1968), consisting of response patterns from 1,000 subjects who attempted to solve three problems (A, B, and C). 
For each problem, responses are coded as (1) solved or (2) not solved. 
The data are provided in the form of a contingency table of response pattern frequencies and are widely used in the context of configural frequency analysis (CFA) and latent structure analysis.<br><br>

<b>Details</b><br>
<table border='0' cellpadding='4'>
<tr><td><b>V1</b> (numeric): Response to problem A (1 = solved, 2 = not solved).</td></tr>
<tr><td><b>V2</b> (numeric): Response to problem B (1 = solved, 2 = not solved).</td></tr>
<tr><td><b>V3</b> (numeric): Response to problem C (1 = solved, 2 = not solved).</td></tr>
<tr><td><b>Freq</b> (numeric): Frequency of each response pattern.</td></tr>
</table><br>

<b>Format</b><br>
The dataset is stored as a pattern frequency table with 8 rows (unique response patterns) and 4 columns. 
The total number of subjects represented in the table is 1,000.<br><br>

<b>References</b><br>
Lazarsfeld, P. F., & Henry, N. W. (1968). 
<i>Latent Structure Analysis.</i> 
Boston: Houghton Mifflin.<br><br>

"

desc_gss82 <- "
<b>Description</b><br>
This dataset contains survey responses from 1,202 white respondents to the 1982 General Social Survey (GSS), focusing on attitudes toward survey participation. 
It includes two dichotomous and two ordinal variables and is commonly used as a teaching and demonstration dataset for latent class analysis (LCA).<br><br>

<b>Details</b><br>
<table border='0' cellpadding='4'>

<tr><td><b>PURPOSE</b> (ordinal): Respondents’ views on the purpose of surveys, coded as 
1 = <i>Waste of time</i>, 
2 = <i>Depends</i>, 
3 = <i>Good</i>.</td></tr>

<tr><td><b>ACCURACY</b> (dichotomous): Respondents’ beliefs about the accuracy of survey results, coded as 
0 = <i>Not true</i>, 
1 = <i>Mostly true</i>.</td></tr>

<tr><td><b>UNDERSTA</b> (ordinal): Respondents’ self-reported understanding of survey questions, coded as 
1 = <i>Fair/Poor</i>, 
2 = <i>Good</i>.</td></tr>

<tr><td><b>COOPERAT</b> (ordinal): Respondents’ level of cooperation with the interviewer, coded as 
1 = <i>Impatient</i>, 
2 = <i>Cooperative</i>, 
3 = <i>Interested</i>.</td></tr>

</table><br>

<b>Notes</b><br>
Higher numeric values indicate more positive attitudes toward survey participation. 
The dataset appears in McCutcheon (1987, p. 30) and is intended for methodological illustration rather than population inference.<br><br>

<b>Source</b><br>
McCutcheon, A. L. (1987). <i>Latent Class Analysis.</i> Newbury Park, CA: SAGE Publications.
"




