% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survstat-loader.R
\name{get_timeseries}
\alias{get_timeseries}
\title{Retrieve time series data from the \code{SurvStat} web service.}
\usage{
get_timeseries(
  disease = NULL,
  measure = c("Count", "Incidence"),
  ...,
  age_group = NULL,
  age_range = c(0, Inf),
  disease_subtype = FALSE,
  years = NULL,
  geography = NULL,
  trim_zeros = c("leading", "both", "none"),
  .progress = TRUE
)
}
\arguments{
\item{disease}{the disease of interest as a \code{SurvStat} key, see
\code{rsurvstat::diseases} for a current list of these. This is technically
optional, and if omitted the counts of all diseases will be returned. Keys
are the same as the options in the \code{SurvStat} user interface found
\href{https://survstat.rki.de/Content/Query/Main.aspx#CreateQuery}{here}. \code{IfSG}
and \code{state} variants of diseases are counts that are reported directly to
the Robert Koch Institute or indirectly via state departments.}

\item{measure}{one of \code{"Count"} (default) or \code{"Incidence"} per 100,000 per
week or year depending on the context.}

\item{...}{not used, must be empty.}

\item{age_group}{(optional) the age group of interest as a \code{SurvStat} key,
see \code{rsurvstat::age_groups} for a list of valid options.}

\item{age_range}{(optional) a length 2 vector with the minimum and maximum
ages to consider}

\item{disease_subtype}{if \code{TRUE} the returned count will be broken down by
disease or pathogen subtype (assuming \code{disease} was provided).}

\item{years}{(optional) a vector of years to limit the response to. This may
be useful to limit the size of returned pages in the event the \code{SurvStat}
service hits a data transfer limit.}

\item{geography}{(optional) a geographical breakdown. This can be given as a
character where it must be one of \code{state}, \code{nuts}, or \code{county} specifying
the 16 region \code{FedStateKey71Map}, 38 region \code{NutsKey71Map}, or 411 region
\code{CountyKey71Map} data respectively. Alternatively it can be given as a
as a \code{sf} dataframe, subsetting one of these maps, in which case only that
subset of regions will be returned.}

\item{trim_zeros}{get rid of zero counts. Either "both" (from start and end),
"leading" (from start only - the default) or "none".}

\item{.progress}{by default a progress bar is shown, which may be important
if many downloads are needed to fulfil the request. It can be disabled
by setting this to \code{FALSE} here.}
}
\value{
a data frame with at least \code{date} (weekly), and one of \code{count} or
\code{incidence} columns. Most likely it will also have \code{disease_name} and
\code{disease_code} columns, and some of \code{age_name}, \code{age_code}, \code{age_low},
\code{age_high}, \code{geo_code}, \code{geo_name}, \code{disease_subtype_code},
\code{disease_subtype_name} depending on options. The dataframe will be grouped
to make sure each group contains a single timeseries.
}
\description{
This function gets a weekly timeseries of disease count or incidence data
from the  Robert Koch Institute \code{SurvStat} web service. The timeseries can be
stratified by any combination of age, geography, disease, disease subtype.
Queries to \code{SurvStat} are cached and paged, but obviously multidimensional
extracts have the potential to need a lot of downloading.
}
\examples{
\donttest{
# age stratified
get_timeseries(
  diseases$`COVID-19`,
  measure = "Count",
  age_group = age_groups$children_coarse
) \%>\% dplyr::glimpse()

# geographic
get_timeseries(
  diseases$`COVID-19`,
  measure = "Count",
  geography = "state"
) \%>\% dplyr::glimpse()

# disease stratified, subset of years:
get_timeseries(
  measure = "Count",
  years = 2024
) \%>\% dplyr::glimpse()
}
}
\concept{survstat}
