\name{TICM-package}
\alias{TICM-package}
\alias{TICM}
\docType{package}
\title{\packageTitle{TICM}}
\description{\packageDescription{TICM}}
\details{
The \pkg{TICM} package implements characteristic-function based, L2-type procedures for
(i) testing total multivariate independence in observed data and (ii) assessing the validity of an
independent component model by testing mutual independence of estimated independent components.

The main user-facing functions are:
\itemize{
  \item \code{\link{ind_test}}: tests complete independence among the columns of a data matrix.
  \item \code{\link{icm_test}}: estimates independent components via ICA (e.g., JADE, FOBI, or FastICA) and
  then performs a total independence test to the estimated components to assess the validity of the independent component model.
  \item \code{\link{plot.ticm}}: diagnostic visualization of the estimated independent components returned by
  \code{icm_test} via a scatterplot matrix.
}

Both testing functions allow optional marginal score transformations (\code{"Identity"}, \code{"Rank"},
\code{"VdW"}) and offer resampling-based inference using either permutation or bootstrap strategies
to approximate p-values.

\strong{Typical workflow}
\enumerate{
  \item Use \code{\link{ind_test}} to test whether the observed variables appear mutually independent.
  \item Use \code{\link{icm_test}} to estimate independent components and test whether the resulting components
  are mutually independent (a diagnostic for the independent component model).
  \item Use \code{plot()} on the \code{ticm} result for a quick visual check of pairwise dependence.
}
}
\author{
\packageAuthor{TICM}

Maintainer: \packageMaintainer{TICM}
}
\references{
Hallin, M., Meintanis, S.G. and Nordhausen, K. (2024),
\emph{Consistent distribution free affine invariant tests for the validity of independent component models}.
arXiv:2404.07632.
}
\seealso{
\code{\link{icm_test}}, \code{\link{ind_test}}
}

\keyword{package}


