% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggSunburst.R
\name{ggSunburst}
\alias{ggSunburst}
\title{ggSunburst}
\usage{
ggSunburst(treatmentPathways, groupCombinations = FALSE, unit = "percent")
}
\arguments{
\item{treatmentPathways}{(\code{data.frame()})\cr
The contents of the treatmentPathways.csv-file as a data.frame().}

\item{groupCombinations}{(\code{logical(1)}: \code{FALSE})\cr
\describe{
\item{\code{TRUE}}{Group all combination treatments in category \code{"Combination"}.}
\item{\code{FALSE}}{Do not group combination treatments.}
}}

\item{unit}{(\code{character(1)}) Either \code{"count"} or \code{"percent"}, to scale the plot to.}
}
\value{
(\code{gg}, \code{ggplot})
}
\description{
ggSunburst
}
\examples{
# Dummy data, typically read from treatmentPathways.csv
treatmentPatwhays <- data.frame(
  pathway = c("Acetaminophen", "Acetaminophen-Amoxicillin+Clavulanate",
           "Acetaminophen-Aspirin", "Amoxicillin+Clavulanate", "Aspirin"),
  freq = c(206, 6, 14, 48, 221),
  sex = rep("all", 5),
  age = rep("all", 5),
  index_year = rep("all", 5)
)

if (interactive()) {
  ggSunburst(treatmentPatwhays)
}
}
