% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventNumber.R
\name{eventNumber}
\alias{eventNumber}
\title{Triggering Condition by Number of Events or Non-missing Observations of an Endpoint}
\usage{
eventNumber(endpoint, n, ..., arms = NULL)
}
\arguments{
\item{endpoint}{character. Name of an endpoint. It should be something that
is specified in the argument \code{name} in \code{endpoint()}.}

\item{n}{integer. Targeted number of events or non-missing obervations,
depending on the type of endpoint.}

\item{...}{subset conditions compatible with \code{dplyr::filter}. Number
of events/observations will be counted on subset of trial data only.}

\item{arms}{vector of character. Name of arms on which the number of
events/observations is counted. If \code{NULL}, use all arms that are not yet
removed from the trial (using \code{remove_arms()})
by the time of calculation.}
}
\value{
an object of class `Condition`
}
\description{
Define a condition to trigger trial milestone by the number of events of a
time-to-event endpoint or the number of non-missing observations of a
non-time-to-event endpoint. The milestone will be triggered when a trial has
observed at least the specified number of endpoint events (or non-missing
observations). It can be used combined with
conditions specified by \link[TrialSimulator]{calendarTime} and
\link[TrialSimulator]{enrollment}.

Number of events for a time-to-event endpoint can vary at different
milestones as more patients are randomized into a trial, or more events
onset over time.

Number of non-missing observations for a non-time-to-event endpoint can vary
at different milestones as more patients are randomized into a trial, or more
patients have been treated until their readout time (thus, \code{NA} turns
to a value).

Both numbers are affected by dropout.

Refer to the
\href{https://zhangh12.github.io/TrialSimulator/articles/conditionSystem.html}{vignette}
to learn how to define milestones when performing simulation using
\code{TrialSimulator}.
}
