% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vca.R
\name{getDDFM}
\alias{getDDFM}
\title{Degrees of Freedom for Testing Linear Contrasts of Fixed Effects and Least Square Means}
\usage{
getDDFM(
  obj,
  L,
  ddfm = c("contain", "residual", "satterthwaite"),
  tol = 1e-12,
  method.grad = "simple",
  opt = TRUE,
  items = NULL
)
}
\arguments{
\item{obj}{(VCA) object}

\item{L}{(numeric) vector specifying the linear combination of the fixed effect or
LS Means}

\item{ddfm}{(character) string specifying the method used for computing the denominator
degrees of freedom for tests of fixed effects or LS Means. Available methods are
"contain", "residual", and "satterthwaite".}

\item{tol}{(numeric) value specifying the numeric tolerance for testing equality to zero}

\item{method.grad}{(character) string specifying the method to be used for approximating the gradient
of the variance-covariance matrix of fixed effects at the estimated covariance parameter
estimates (see function 'grad' (numDeriv) for details)}

\item{opt}{(logical) TRUE = tries to optimize computation time by avoiding unnecessary computations
for balanced datasets (see \code{\link{test.fixef}}).}

\item{items}{(list) of pre-computed values}
}
\value{
(numeric) vector with the specified type of degrees of freedom
}
\description{
There are three methods implemented, which are all available in SAS PROC MIXED, namely 
"contain", "residual", and "satterthwaite" approximations. See the documentation of SAS
PROC MIXED for details on this topic.
}
\details{
The implementation of the Satterthwaite approximation was inspired by the code of function 
'calcSatterth' of R-package 'lmerTest'.
}
\seealso{
\code{\link{test.fixef}}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
