% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checking.R
\name{rename_columns}
\alias{rename_columns}
\title{Rename default column names for interest areas.}
\usage{
rename_columns(data, Labels = NULL)
}
\arguments{
\item{data}{A data table object output by either \code{\link{bin_prop}}. 
\code{\link{transform_to_elogit}}, or \code{\link{create_binomial}}.}

\item{Labels}{A named character vector specifying the interest areas and the
desired names to be inserted in place of the numerical labelling.}
}
\value{
A data table object with renamed columns.
}
\description{
\code{rename_columns} will replace the default numerical coding of the 
interest area columns with more meaningful user-specified names. For example,
IA_1_C and IA_1_P could be converted to IA_Target_C and IA_Target_P. Again, 
this will work for upto 8 interest areas.
}
\examples{
\dontrun{
library(VWPre)
# For renaming default interest area columns
dat2 <- rename_columns(dat, Labels = c(IA1="Target", IA2="Rhyme", 
                           IA3="OnsetComp", IA4="Distractor")) 
}
}
