% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{emps}
\alias{emps}
\title{Calculate expected minimum population size (EMPS)
  for a \code{\link{simulate}} object}
\usage{
emps(sims, subset = NULL, times = NULL, fun = mean, ...)
}
\arguments{
\item{sims}{an object returned from \code{\link{simulate}}}

\item{subset}{\code{integer} vector denoting the population classes
to include in calculation of population abundance. Defaults to
all classes}

\item{times}{\code{integer} vector specifying generations to
include in calculation of extinction risk. Defaults to all
simulated generations}

\item{fun}{\code{function} used to calculate average over all
replicate trajectories. Defaults to \code{mean}. Alternatives
might include \code{median} or \code{min}}

\item{\dots}{additional arguments passed to \code{fun}}
}
\value{
a single value representing the expected minimum population
  size for a simulation
}
\description{
Calculate expected minimum population size (EMPS)
  for a \code{\link{simulate}} object
}
\details{
Expected minimum population size (EMPS) is the average
  minimum value of all replicate trajectories. This value represents
  an expected lower bound on population sizes over all generations,
  accounting for variation among replicates. Abundances
  can be specified for all population classes or for a subset
  of classes.
}
\examples{
# define a basic population
nstage <- 5
popmat <- matrix(0, nrow = nstage, ncol = nstage)
popmat[reproduction(popmat, dims = 4:5)] <- c(10, 20)
popmat[transition(popmat)] <- c(0.25, 0.3, 0.5, 0.65)

# define a dynamics object
dyn <- dynamics(popmat)

# simulate with the default updater
sims <- simulate(dyn, nsim = 1000)

# calculate expected minimum population size
emps(sims)

# calculate expected minimum population size for 4 and 5 year
#   olds only
emps(sims, subset = 4:5)

# calculate expected minimum population size but ignore first 10 years
emps(sims, times = 11:51)

# calculate expected minimum population size based on median
emps(sims, fun = median)
}
