% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_afeye.R
\name{derive_var_afeye}
\alias{derive_var_afeye}
\title{Derive Affected Eye}
\usage{
derive_var_afeye(dataset, loc_var, lat_var, loc_vals = "EYE")
}
\arguments{
\item{dataset}{Input dataset.

\describe{
\item{Permitted values}{a dataset, i.e., a \code{data.frame} or tibble}
\item{Default value}{none}
}}

\item{loc_var}{Location variable, usually \code{XXLOC}.

\describe{
\item{Permitted values}{an unquoted symbol, e.g., \code{AVAL}}
\item{Default value}{none}
}}

\item{lat_var}{Laterality variable, usually \code{XXLAT}.

\describe{
\item{Permitted values}{an unquoted symbol, e.g., \code{AVAL}}
\item{Default value}{none}
}}

\item{loc_vals}{\code{xxLOC} values for which \code{AFEYE} is derived.

\describe{
\item{Permitted values}{a character vector, e.g. \code{c("EYE", "RETINA")}}
\item{Default value}{\code{"EYE"}}
}}
}
\value{
The input occurrence dataset with Affected Eye (\code{AFEYE}) added.
}
\description{
Derive Affected Eye (\code{AFEYE}) in occurrence datasets
}
\details{
Affected Eye is derived in the occurrence dataset using laterality and Study
Eye. This assumes Study Eye has already been added from ADSL.
}
\examples{
library(tibble)
library(admiral)

adae1 <- tribble(
  ~STUDYID, ~USUBJID, ~STUDYEYE, ~AELOC, ~AELAT,
  "XXX001", "P01", "RIGHT", "EYE", "RIGHT",
  "XXX001", "P01", "RIGHT", "EYE", "LEFT",
  "XXX001", "P01", "RIGHT", "EYE", "",
  "XXX001", "P01", "RIGHT", "", "RIGHT",
  "XXX001", "P02", "LEFT", "", "",
  "XXX001", "P02", "LEFT", "EYE", "LEFT",
  "XXX001", "P04", "BILATERAL", "EYE", "RIGHT",
  "XXX001", "P05", "RIGHT", "EYE", "RIGHT",
  "XXX001", "P05", "RIGHT", "EYE", "BILATERAL",
  "XXX001", "P06", "BILATERAL", "", "",
  "XXX001", "P06", "BILATERAL", "", "RIGHT",
  "XXX001", "P07", "BILATERAL", "EYE", "BILATERAL",
  "XXX001", "P08", "", "EYE", "BILATERAL",
  "XXX001", "P09", "NONSENSE", "EYE", "BILATERAL",
  "XXX001", "P09", "BILATERAL", "EYE", "NONSENSE",
  "XXX001", "P09", "BILATERAL", "NONSENSE", "BILATERAL",
  "XXX001", "P10", "RIGHT", "EYE", "BOTH"
)

derive_var_afeye(adae1, loc_var = AELOC, lat_var = AELAT)

adae2 <- tribble(
  ~STUDYID, ~USUBJID, ~STUDYEYE, ~AELOC, ~AELAT,
  "XXX001", "P01", "RIGHT", "EYES", "RIGHT",
  "XXX001", "P02", "RIGHT", "RETINA", "LEFT",
  "XXX001", "P03", "LEFT", "", ""
)

derive_var_afeye(adae2, loc_var = AELOC, lat_var = AELAT, loc_vals = c("EYES", "RETINA"))
}
\author{
Lucy Palmen
}
\keyword{der_occds}
