% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DKI_v1.R
\name{DKI}
\alias{DKI}
\title{Calculates DKI (\emph{v1})}
\usage{
DKI(AMBI, H, N, S, H_max = 5)
}
\arguments{
\item{AMBI}{AMBI, the AZTI Marine Biotic Index, calculated using \code{\link[=AMBI]{AMBI()}}}

\item{H}{H', the Shannon diversity index, calculated using \code{\link[=Hdash]{Hdash()}}}

\item{N}{number of individuals - generated by both \code{\link[=AMBI]{AMBI()}} and \code{\link[=Hdash]{Hdash()}}}

\item{S}{number of species - generated by both \code{\link[=AMBI]{AMBI()}} and \code{\link[=Hdash]{Hdash()}}}

\item{H_max}{maximum H' used to normalise AMBI, \emph{default 5}}
}
\value{
\code{DKI} index value
}
\description{
\code{\link[=DKI]{DKI()}} calculates the original version of the Danish quality index DKI
\href{#references}{(Carstensen et al., 2014)}

The DKI is based on AMBI and can only be calculated after first calculating
\emph{AMBI}, the AZTI Marine Biotic Index, and \emph{H'}, the Shannon diversity index.
Both indices are included in output from the function \code{\link[=AMBI]{AMBI()}}.

The function uses an estimated maximum possible value of H' \code{H_max} in Danish
waters as a reference value to normalise DKI. If this value is not specified
as an argument, the default value is used \code{5.0}

\emph{"However, in the present exercise, the Danish method used \eqn{H_{max}} (~5) as a kind of reference"}
\href{#references}{(Borja et al., 2007)}
}
\details{
The \code{\link[=AMBI]{AMBI()}} and \code{\link[=Hdash]{Hdash()}} functions take a dataframe of observations as an
argument. The DKI functions, \code{\link[=DKI2]{DKI2()}} and \code{\link[=DKI]{DKI()}}, do \emph{not} take a dataframe
as an argument. Instead they take values of the input parameters, either
single values or as vectors.

To calculate DKI for a dataframe of \code{AMBI} values, it could be called from
e.g. within a \code{\link[dplyr:mutate]{dplyr::mutate()}} function call. See the examples below.
}
\examples{

# Simple example

DKI(AMBI = 1.61, H = 2.36, N = 25, S = 6)


# ------ Example workflow for calculating DKI from species counts ----

# calculate AMBI index
dfAMBI <- AMBI(test_data, by = c("station"), var_rep="replicate")[["AMBI"]]

# show AMBI results
dfAMBI

# calculate DKI from AMBI results
dplyr::mutate(dfAMBI, DKI = DKI(AMBI, H, N, S))

}
\references{
Borja, A., Josefson, A., Miles, A., Muxika, I., Olsgard, F., Phillips, G., Rodriguez, J., Rygg, B. (2007). An Approach to the Intercalibration of Benthic Ecological Status Assessment in the North Atlantic Ecoregion, According to the European Water Framework Directive. \emph{Marine Pollution Bulletin}, 55(1-6), 42-52. #' \doi{doi:10.1016/j.marpolbul.2006.08.018}

Carstensen, J., Krause-Jensen, D., Josefson, A. (2014). "Development and testing of tools for intercalibration of phytoplankton, macrovegetation and benthic fauna in Danish coastal areas." Aarhus University, DCE – Danish Centre for Environment and Energy, 85 pp. \emph{Scientific Report from DCE – Danish Centre for Environment and Energy} No. 93.
\url{https://dce2.au.dk/pub/SR93.pdf}
}
\seealso{
DKI v1 has been superseded by \code{\link[=DKI2]{DKI2()}} a salinity-normalised version of DKI.
}
