% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_nhx.R
\name{read_nhx}
\alias{read_nhx}
\title{Read New Hampshire eXtended format for trees}
\usage{
read_nhx(fn, txt)
}
\arguments{
\item{fn}{Full path to the tree file.}

\item{txt}{If no file is specified, trees can also be passed as
a character scalar (see examples).}
}
\value{
A list with the following elements:
\itemize{
\item tree An object of class \code{ape}
\item edge Edge annotations (length and other annotations)
\item nhx A list of annotations NHX
}
}
\description{
Read New Hampshire eXtended format for trees
}
\examples{
# Example directly extracted from
# https://sites.google.com/site/cmzmasek/home/software/forester/nhx
read_nhx(
  txt = "(((ADH2:0.1[&&NHX:S=human], ADH1:0.11[&&NHX:S=human]):0.05[&&NHX:S=primates:D=Y:B=100],
    ADHY:0.1[&&NHX:S=nematode],ADHX:0.12[&&NHX:S=insect]):0.1[&&NHX:S=metazoa:D=N],
    (ADH4:0.09[&&NHX:S=yeast],ADH3:0.13[&&NHX:S=yeast], ADH2:0.12[&&NHX:S=yeast],
    ADH1:0.11[&&NHX:S=yeast]):0.1 [&&NHX:S=Fungi])[&&NHX:D=N];"
    )
}
\references{
"NHX - New Hampshire eXtended [version 2.0]",
\url{https://en.wikipedia.org/wiki/Newick_format#New_Hampshire_X_format}
}
\seealso{
Other reading: 
\code{\link{panther-tree}},
\code{\link{read_pli}()}
}
\concept{reading}
