% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_traffic_mirror_target}
\alias{ec2_create_traffic_mirror_target}
\title{Create Traffic Mirror Target}
\usage{
ec2_create_traffic_mirror_target(
  NetworkInterfaceId = NULL,
  NetworkLoadBalancerArn = NULL,
  Description = NULL,
  TagSpecification = NULL,
  DryRun = NULL,
  ClientToken = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{NetworkInterfaceId}{Character. The network interface ID that is associated with the target.[optional]}

\item{NetworkLoadBalancerArn}{Character. The Amazon Resource Name (ARN) of the Network Load Balancer that is associated with the target.[optional]}

\item{Description}{Character. The description of the Traffic Mirror target.[optional]}

\item{TagSpecification}{List. The tags to assign to the Traffic Mirror target.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{ClientToken}{Character. Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Create Traffic Mirror Target
}
\section{NetworkInterfaceId}{

The
network interface ID that is associated with the
target.
}

\section{NetworkLoadBalancerArn}{

The Amazon Resource Name (ARN) of the
Network Load Balancer that is associated with the
target.
}

\section{Description}{

The description of the Traffic Mirror
target.
}

\section{TagSpecification}{

The tags to assign to the Traffic Mirror
target.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{ClientToken}{

Unique, case-sensitive
identifier that you provide to ensure the idempotency of the request.
For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{How to Ensure Idempotency}.
}

