% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_fpga_images}
\alias{ec2_describe_fpga_images}
\title{Describe Fpga Images}
\usage{
ec2_describe_fpga_images(
  DryRun = NULL,
  FpgaImageId = NULL,
  Owner = NULL,
  Filter = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{FpgaImageId}{List. The AFI IDs.[optional]}

\item{Owner}{List. Filters the AFI by owner.[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{NextToken}{Characters. The token for the next page of results[optional]}

\item{MaxResults}{Integer. The maximum number of results to return in a single call.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Describes the
Amazon FPGA Images (AFIs) available to you. These include public AFIs,
private AFIs that you own, and AFIs owned by other AWS accounts for
which you have load permissions.
}
\section{DryRun}{

Checks
whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

\section{FpgaImageId}{

The AFI
IDs.
}

\section{Owner}{

Filters the AFI by owner. Specify an AWS
account ID, \code{self} (owner is the sender of the request), or an AWS owner
alias (valid values are \code{amazon} \|
\code{aws-marketplace}).
}

\section{Filter}{


The filters.
\itemize{
\item \code{create-time} - The creation time of the AFI.
\item \code{fpga-image-id} - The FPGA image identifier (AFI ID).
\item \code{fpga-image-global-id} - The global FPGA image identifier (AGFI ID).
\item \code{name} - The name of the AFI.
\item \code{owner-id} - The AWS account ID of the AFI owner.
\item \code{product-code} - The product code.
\item \code{shell-version} - The version of the AWS Shell that was used to
create the bitstream.
\item \code{state} - The state of the AFI (\code{pending} \| \code{failed} \| \code{available}
\| \code{unavailable}).
\item \code{tag}:\ - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{update-time} - The time of the most recent update.
}
}

\section{MaxResults}{

The maximum number of results to return in
a single call.
}

