% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_snapshot_attribute}
\alias{ec2_modify_snapshot_attribute}
\title{Modify Snapshot Attribute}
\usage{
ec2_modify_snapshot_attribute(
  SnapshotId,
  Attribute = NULL,
  CreateVolumePermission = NULL,
  UserGroup = NULL,
  OperationType = NULL,
  UserId = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{SnapshotId}{Character. The ID of the snapshot.}

\item{Attribute}{Character. The snapshot attribute to modify. Only volume creation permissions can be modified.[optional]}

\item{CreateVolumePermission}{Object. A JSON representation of the snapshot attribute modification.[optional]}

\item{UserGroup}{List. The group to modify for the snapshot.[optional]}

\item{OperationType}{Character. The type of operation to perform to the attribute.[optional]}

\item{UserId}{List. The account ID to modify for the snapshot.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Modify Snapshot Attribute
}
\section{SnapshotId}{

The
ID of the snapshot.
}

\section{Attribute}{

The snapshot attribute to
modify. Only volume creation permissions can be
modified.
}

\section{CreateVolumePermission}{

A JSON representation of the snapshot
attribute modification.
}

\section{UserGroup}{

The group to modify for the
snapshot.
}

\section{OperationType}{

The type of operation to perform to the
attribute.
}

\section{UserId}{

The account ID to modify for the
snapshot.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

