% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{count_divergences}
\alias{count_divergences}
\title{Count HMC divergences}
\usage{
count_divergences(fit)
}
\arguments{
\item{fit}{Fitted Stan model object (CmdStanMCMC or stanfit)}
}
\value{
Integer. Number of divergent transitions (post-warmup).
}
\description{
Extracts the number of divergent transitions from a fitted Stan model.
}
\examples{
\donttest{
# Create a "mock" CmdStanMCMC object for demonstration
# (This simulates a model with 0 divergences)
mock_fit <- structure(list(
  sampler_diagnostics = function() {
    # Return a 3D array: [iterations, chains, variables]
    # Variable 1 is usually accept_stat__, let's say var 2 is divergent__
    ar <- array(0, dim = c(100, 4, 6)) 
    dimnames(ar)[[3]] <- c("accept_stat__", "divergent__", "energy__", 
                           "n_leapfrog__", "stepsize__", "treedepth__")
    return(ar)
  }
), class = "CmdStanMCMC")

# Now the example can run without errors:
n_div <- count_divergences(mock_fit)
print(n_div)
}

}
