% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitbccv.gammasp.R
\name{fitbccv.gammasp}
\alias{fitbccv.gammasp}
\title{Bivariate correlated gamma frailty model fitting function.}
\usage{
fitbccv.gammasp(
  X,
  Y,
  initfrailp,
  weights = NULL,
  control = bcfrailph.control(),
  SE = TRUE
)
}
\arguments{
\item{X}{Matix of predictors. This should not include an intercept.}

\item{Y}{a Surv object containing 2 columns (coxph.fit).}

\item{initfrailp}{Initial estimates for the frailty parameters. If not specified, initial frailty variance will be obtained from coxph with univariate gamma frailty model and for correlation c(0.5) will be used.}

\item{weights}{vector of case weights. the default is NULL.}

\item{control}{Arguments to control the fit. The default is \code{\link{bcfrailph.control}}.}

\item{SE}{a logical statement whether standard errors are obtained from the mariginal log likelihood.The default is TRUE.}
}
\value{
An object of  that contains  the following components.
\itemize{
  \item \code{coefficients} - A vector of estimated Covariate coefficients.
  \item \code{frailparest} - A vector of estimated Frailty parameters i.e. frailty variance and correlation.
  \item \code{stderr}-A vector containing the Standard error of the Estimated parameters both covariate coefficients and  frailty parameters.
  \item \code{loglilk0}- Log likelihood of without frailty model or loglik of coxph fit.
  \item \code{loglilk}-Log likelihood of Cox PH model with frailty.
  \item \code{Iloglilk}- Log likelihood of with frailty. For gamma fit it is I-likelihood or the likelihood after integrating out the frailty term.For lognormal fit it is the approximate likelihood.
  \item \code{bhaz}- an array containing unique event times and estimated baseline hazard.
  \item \code{X}-Matrix of observed covariates.
  \item \code{time}-the observed survival time.
  \item \code{censor}-censoring indicator.
  \item \code{resid}-the martingale residuals.
  \item \code{lin.prid}-the vector of linear predictors.
  \item \code{frail}-estimated Frailty values.
  \item \code{iteration}-Number of outer iterations.
  \item \code{e.time}-the vector of unique event times.
  \item \code{n.event}- the number of events at each of the unique event times.
  \item \code{convergence}-an indicator, 1 if converge and 0 otherwise.
  \item \code{history}-an array containing records of estimates and other information on each iterations.
  }
}
\description{
Semi-parametric Bivariate correlated gamma frailty model fitting function.
}
\note{
This function is important especially for simulation studies as it reduced checking time.
Parameters of Bivariate correlated gamma frailty model was estimated using a modified EM approach given in Kifle et al (2022).
}
\examples{
set.seed(4)
simdata<-simbcfrail(psize=300, cenr= c(0.3),beta=c(2),frailty=c("gamma"),
frailpar=c(0.5,0.5),bhaz=c("weibull"),
bhazpar=list(shape =c(5), scale = c(0.1)),
covartype= c("B"),covarpar=list(fargs=c(1),sargs=c(0.5)))
Y<-simdata$Y;X<-simdata$X

bcspfit<-fitbccv.gammasp(X=X,Y=Y,initfrailp=NULL)
bcspfit$coef
bcspfit$frailpar


}
\references{
Kifle YG, Chen DG, Haileyesus MT (2022). Multivariate Frailty Models using Survey Weights with Applications to Twins Infant Mortality in Ethiopia. Statistics and Its Interface,106(4), 1\-10.
}
\seealso{
\code{\link{bcfrailph}}
}
