% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{is_binomen}
\alias{is_binomen}
\alias{generic_name}
\alias{specific_name}
\alias{strip_sp}
\title{Binomial Names}
\usage{
is_binomen(x)

generic_name(x)

specific_name(x)

strip_sp(x)
}
\arguments{
\item{x}{\code{\link{character}} vector, containing the binomial name(s) of
species (a.k.a. binomen or scientific name)}
}
\value{
character vector with either the generic name or the specific name
     of the species.
}
\description{
\code{is_binomial} tests for valid binomial names,
\code{generic_name} extracts the genus to which the species belongs,
\code{specific_name} extracts the species within the genus.
}
\section{Functions}{
\itemize{
\item \code{generic_name()}: extracts the genus to which the species belongs

\item \code{specific_name()}: extracts the species within the genus

\item \code{strip_sp()}: strips postfix sp. or spp. from a binomen

}}
\examples{
 is_binomen("Venerupis corrugata") # TRUE
 generic_name("Venerupis corrugata") # Venerupis
 specific_name("Venerupis corrugata") # corrugata
 generic_name("venerupis corrugata") # NA (genus part should be capitalized)

}
