% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{mergeKeywords}
\alias{mergeKeywords}
\title{Merge DE and ID Fields into a Unified Keywords Column}
\usage{
mergeKeywords(M, force = FALSE)
}
\arguments{
\item{M}{A dataframe containing at least the `DE` and/or `ID` columns, typically generated by `convert2df()` from the `bibliometrix` package.}

\item{force}{Logical. If `TRUE`, an existing `KW_Merged` column will be overwritten. Default is `FALSE`.}
}
\value{
A dataframe with an added (or updated) `KW_Merged` column containing deduplicated and cleaned keyword strings.
}
\description{
This function creates a new column `KW_Merged` by combining the contents of the `DE` (author keywords) and `ID` (keywords plus) fields
in a bibliographic dataframe. Duplicate keywords within each record are removed, and leading/trailing spaces are trimmed.
The merged keywords are separated by a semicolon (`;`).
}
\details{
If the `KW_Merged` column already exists, it will not be overwritten unless `force = TRUE` is specified.
}
\examples{
\dontrun{
data(management, package = "bibliometrix")
M <- mergeKeywords(management)
head(M$KW_Merged)
}

}
