% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddGenericFunctions.R
\name{ExpTests}
\alias{ExpTests}
\title{Access the expected number of tests from an object}
\usage{
ExpTests(object, ...)
}
\arguments{
\item{object}{An object for which a summary of the expected number of tests is desired.}

\item{...}{Additional arguments to be passed to \code{ExpTests}.}
}
\value{
The value return depends on the class of its object. See the documentation
  for the corresponding method functions.
}
\description{
\code{ExpTests} is a generic function that extracts the expected
  number of tests from an object that contains information
  aboout a testing configuration.
}
\examples{
# Find the optimal testing configuration for
#   non-informative two-stage hierarchical testing.
res1 <- OTC1(algorithm = "D2", p = 0.01, Se = 0.99, Sp = 0.99,
             group.sz = 2:100, obj.fn = c("ET", "MAR", "GR1"),
             weights = matrix(data = c(1,1), nrow = 1, ncol = 2))
ExpTests(res1)
}
\seealso{
\code{\link{ExpTests.opChar}} and \code{\link{ExpTests.OTC}}
}
\author{
Christopher R. Bilder
}
