% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbz_eta.R
\name{eta_to_dbz}
\alias{eta_to_dbz}
\title{Convert reflectivity (eta) to reflectivity factor (dBZ)}
\usage{
eta_to_dbz(eta, wavelength, K = sqrt(0.93))
}
\arguments{
\item{eta}{Numeric. Reflectivity, in cm^2/km^3.}

\item{wavelength}{Numeric. Radar wavelength, in cm.}

\item{K}{Numeric. Norm of the complex refractive index of water.}
}
\value{
Reflectivity factor, in dBZ.
}
\description{
Converts reflectivity (eta) to reflectivity factor (dBZ).
}
\examples{
# Calculate dBZ for a 10000 cm^2/km^3 eta reflectivity at C-band
eta_to_dbz(10000, 5)

# Calculate dBZ for a 10000 cm^2/km^3 eta reflectivity at S-band
eta_to_dbz(10000, 10)

# Calculate dBZ for an animal density of 1000 individuals/km^3 and a radar
# cross section of 11 cm^2 per individual
eta_to_dbz(1000 * 11, 5) # C-band
eta_to_dbz(1000 * 11, 10) # S-band
}
