% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_pvolfile.R
\name{write_pvolfile}
\alias{write_pvolfile}
\title{Write a polar volume (\code{pvol}) object to ODIM HDF5 file}
\usage{
write_pvolfile(pvol, file, overwrite = FALSE, infer_dtype = FALSE)
}
\arguments{
\item{pvol}{An object of class \code{pvol}.}

\item{file}{string. A filepath to write the \code{pvol} object to.}

\item{overwrite}{logical. Overwrites existing file when TRUE.}

\item{infer_dtype}{logical. By default (infer_dtype = FALSE) writes 'params'
back into ODIM HDF5 files with data stored in original data types. When TRUE
infers data type from the R object data type, at the cost of (heavily) inflated file sizes.}
}
\value{
0 on success. A \code{pvol} object will be written to file in ODIM H5 format.
}
\description{
Write a polar volume (\code{pvol}) object to ODIM HDF5 file
}
\examples{
# locate example volume file:
pvolfile <- system.file("extdata", "volume.h5", package = "bioRad")

# load the file:
example_pvol <- read_pvolfile(pvolfile)

# write the file:
pvolfile_out <- paste0(tempdir(),"pvolfile_out.h5")
write_pvolfile(example_pvol, pvolfile_out)

# clean up
file.remove(pvolfile_out)
}
