% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_bm_list.R
\name{is_supported_bitmap}
\alias{is_supported_bitmap}
\title{Test if the object is a bitmap object supported by the methods in this package}
\usage{
is_supported_bitmap(x)
}
\arguments{
\item{x}{An object}
}
\value{
\code{TRUE} or \code{FALSE}
}
\description{
\code{is_supported_bitmap()} returns \code{TRUE} for \code{bm_bitmap}, \code{bm_pixmap}, \code{magick-image}, \code{nativeRaster}, and \code{raster} objects (or subclasses)
and \code{FALSE} for all other objects.
}
\examples{
space_matrix <- matrix(0L, nrow = 16L, ncol = 16L)
space_glyph <- bm_bitmap(space_matrix)
is_supported_bitmap(space_glyph)
}
\seealso{
\code{\link[=is_bm_bitmap]{is_bm_bitmap()}}, \code{\link[=is_bm_pixmap]{is_bm_pixmap()}}, \code{\link[grDevices:as.raster]{grDevices::is.raster()}}
}
