% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-prep.R
\name{standardize_continuous}
\alias{standardize_continuous}
\title{Standardize Continuous Columns}
\usage{
standardize_continuous(
  DT,
  cols,
  method = c("zscore", "robust"),
  center = TRUE,
  scale = TRUE
)
}
\arguments{
\item{DT}{A data.table or data.frame.}

\item{cols}{Character vector of column names to standardize.}

\item{method}{Character; either "zscore" or "robust".}

\item{center}{Logical; whether to center the data.}

\item{scale}{Logical; whether to scale the data.}
}
\value{
A list with components:
\item{DT}{The standardized data.table.}
\item{scalers}{A list of scaling parameters for each column.}
}
\description{
Standardizes selected numeric columns using z-score or robust
(median/MAD) methods. Binary columns (0/1) are left unchanged.
}
