% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_list.R
\name{sim_list}
\alias{sim_list}
\title{Create a sim_list object from a list of spatial interaction objects}
\usage{
sim_list(sims, validate = TRUE)
}
\arguments{
\item{sims}{a list of homogeneous spatial interaction objects}

\item{validate}{should the function validate the homogeneity of the list of
spatial interaction objects (defaults to \code{TRUE})}
}
\value{
a \code{sim_list} object
}
\description{
The collection of \code{sim} objects represented by a \code{sim_list} object is assumed
to be homogeneous, that is to correspond to a fix set of origin and
destination locations, associated to a fixed cost matrix.
}
\examples{
positions <- matrix(rnorm(10 * 2), ncol = 2)
distances <- as.matrix(dist(positions))
production <- rep(1, 10)
attractiveness <- c(2, rep(1, 9))
flows_1 <- blvim(distances, production, 1.5, 1, attractiveness)
flows_2 <- blvim(distances, production, 1.25, 2, attractiveness)
all_flows <- sim_list(list(flows_1, flows_2))
}
