% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypergeometric_distribution.R
\name{hypergeometric_distribution}
\alias{hypergeometric_distribution}
\alias{hypergeometric_pdf}
\alias{hypergeometric_lpdf}
\alias{hypergeometric_cdf}
\alias{hypergeometric_lcdf}
\alias{hypergeometric_quantile}
\title{Hypergeometric Distribution Functions}
\usage{
hypergeometric_distribution(r, n, N)

hypergeometric_pdf(x, r, n, N)

hypergeometric_lpdf(x, r, n, N)

hypergeometric_cdf(x, r, n, N)

hypergeometric_lcdf(x, r, n, N)

hypergeometric_quantile(p, r, n, N)
}
\arguments{
\item{r}{number of successes in the population (r >= 0)}

\item{n}{number of draws (n >= 0)}

\item{N}{population size (N >= r)}

\item{x}{quantile (non-negative integer)}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Hypergeometric distribution.
}
\examples{
# Hypergeometric distribution with r = 5, n = 10, N = 20
dist <- hypergeometric_distribution(5, 10, 20)
# Apply generic functions
cdf(dist, 4)
logcdf(dist, 4)
pdf(dist, 4)
logpdf(dist, 4)
hazard(dist, 4)
chf(dist, 4)
mean(dist)
median(dist)
mode(dist)
range(dist)
quantile(dist, 0.2)
standard_deviation(dist)
support(dist)
variance(dist)
skewness(dist)
kurtosis(dist)
kurtosis_excess(dist)

# Convenience functions
hypergeometric_pdf(3, 5, 10, 20)
hypergeometric_lpdf(3, 5, 10, 20)
hypergeometric_cdf(3, 5, 10, 20)
hypergeometric_lcdf(3, 5, 10, 20)
hypergeometric_quantile(0.5, 5, 10, 20)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/hypergeometric_dist.html}{Boost Documentation} for more details on the mathematical background.
}
