% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_selic_rate.R
\name{get_selic_rate}
\alias{get_selic_rate}
\title{Get Annual Brazilian SELIC Rate (Annualized, Base 252)}
\usage{
get_selic_rate(
  start_date = "2020-01-01",
  end_date = NULL,
  language = "eng",
  labels = TRUE
)
}
\arguments{
\item{start_date}{Start date for the data period. Accepts multiple formats:
\itemize{
\item \code{"YYYY"} for year only (e.g., \code{"2020"} becomes \code{"2020-01-01"})
\item \code{"YYYY-MM"} for year and month (e.g., \code{"2020-06"} becomes \code{"2020-06-01"})
\item \code{"YYYY-MM-DD"} for a specific date (e.g., \code{"2020-06-15"})
\item \code{NULL} defaults to \code{"2020-01-01"} (sensible default for analysis)
}}

\item{end_date}{End date for the data period. Accepts the same formats as \code{start_date}:
\itemize{
\item \code{"YYYY"} (e.g., \code{"2023"} becomes \code{"2023-12-31"})
\item \code{"YYYY-MM"} (e.g., \code{"2023-12"} becomes the last day of December 2023)
\item \code{"YYYY-MM-DD"} for a specific date
\item \code{NULL} defaults to the current date (today)
}}

\item{language}{Language for column names in the returned data.frame:
\itemize{
\item \code{"eng"} (default): Returns columns \code{date} and \code{selic_rate}
\item \code{"pt"}: Returns columns \code{data_referencia} and \code{taxa_selic}
}}

\item{labels}{Logical indicating whether to add variable labels using the \code{labelled}
package. Labels provide descriptive text for each column when available.}
}
\value{
A data.frame with SELIC rate. Columns depend on the \code{language} parameter:
\itemize{
\item English (\code{language = "eng"}): \code{date} (Date), \code{selic_rate} (numeric, \% per year)
\item Portuguese (\code{language = "pt"}): \code{data_referencia} (Date), \code{taxa_selic} (numeric, \% ao ano)
}
}
\description{
Downloads the annual SELIC rate series from the Central Bank of Brazil's SGS API.
The SELIC rate (Special System for Settlement and Custody) is Brazil's benchmark
overnight interest rate, used as the primary monetary policy instrument.
}
\note{
\strong{IMPORTANT API LIMITATION}: The BCB API imposes a \strong{10-year maximum window}
for daily frequency series like SELIC. Requests spanning more than 10 years will fail.
For longer historical analyses, split your request into multiple 10-year periods.

\strong{DEFAULT PERIOD}: When \code{start_date = NULL}, defaults to \code{"2020-01-01"} (start of 2020),
providing recent data while avoiding the 10-year API limit with current dates.
}
\examples{
\dontrun{
  # Default: from 2020 to current date
  df <- get_selic_rate()

  # Specific period within 10-year limit
  df2 <- get_selic_rate("2020-01-01", "2023-12-31")

  # Last 5 years (respecting 10-year limit)
  df3 <- get_selic_rate(start_date = "2019")

  # Portuguese column names and labels
  df4 <- get_selic_rate(language = "pt")

  # Complete year analysis
  df5 <- get_selic_rate("2018", "2023")
}

}
