% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cTMed-methods-ctmedmed.R
\name{plot.ctmedmed}
\alias{plot.ctmedmed}
\title{Plot Method for an Object of Class \code{ctmedmed}}
\usage{
\method{plot}{ctmedmed}(x, col = NULL, legend_pos = "topright", ...)
}
\arguments{
\item{x}{Object of class \code{ctmedmed}.}

\item{col}{Character vector.
Optional argument.
Character vector of colors.}

\item{legend_pos}{Character vector.
Optional argument.
Legend position.}

\item{...}{Additional arguments.}
}
\value{
Displays plots of point estimates and confidence intervals.
}
\description{
Plot Method for an Object of Class \code{ctmedmed}
}
\examples{
phi <- matrix(
  data = c(
    -0.357, 0.771, -0.450,
    0.0, -0.511, 0.729,
    0, 0, -0.693
  ),
  nrow = 3
)
colnames(phi) <- rownames(phi) <- c("x", "m", "y")

# Range of time intervals ---------------------------------------------------
med <- Med(
  phi = phi,
  delta_t = 1:5,
  from = "x",
  to = "y",
  med = "m"
)
plot(med)

}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
