% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indirect_standardized_incidence_ratio.R
\name{indirect_standardized_incidence_ratio}
\alias{indirect_standardized_incidence_ratio}
\title{Compute indirect standardized incidence ratio (sir)}
\usage{
indirect_standardized_incidence_ratio(
  ncan,
  py,
  ncanref,
  pyref,
  ncan.min = 5,
  py.min = 0
)
}
\arguments{
\item{ncan}{integer, (age-specific) number of cancers in the population of interest}

\item{py}{integer, (age-specific) person-year of the the population of interest}

\item{ncanref}{integer, (age-specific) number of cancers in the reference population}

\item{pyref}{integer, (age-specific) person-year of the the reference population}

\item{ncan.min}{integer, minimum number of observation required not to mask the CI's out}

\item{py.min}{integer, minimum number of person-years required not to mask the CI's out

Standardized incidence ratio (sir) and associated 95\% confidence interval are computing assuming normal distribution of the pir on the log scale.
sir is a summary statistics that should be computed per group of individuals providing age specific counts.}
}
\value{
a 1 line and 3 column data.frame containing the sir (est) and associated 95\% CI (lci, uci)
}
\description{
Compute indirect standardized incidence ratio (sir)
}
\examples{
ncan <- 1:10
py <- 101:110
ncanref <- 41:50
pyref <- 251:260
ncan.min <- 5

indirect_standardized_incidence_ratio(ncan, py, ncanref, pyref, ncan.min)
indirect_standardized_incidence_ratio(ncan, py, ncanref, pyref, sum(ncan) + 1)
}
\references{
Boyle P, Parkin DM. Cancer registration: principles and methods. Statistical methods for registries. IARC Sci Publ. 1991;(95):126-58. PMID: 1894318.
}
\concept{summary-stat}
