% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{caugi_layout_fruchterman_reingold}
\alias{caugi_layout_fruchterman_reingold}
\title{Fruchterman-Reingold Force-Directed Layout}
\source{
Fruchterman, T. M. J., & Reingold, E. M. (1991). Graph drawing by
force-directed placement. Software: Practice and Experience, 21(11),
1129-1164. \doi{10.1002/spe.4380211102}
}
\usage{
caugi_layout_fruchterman_reingold(x, packing_ratio = 1.618034, ...)
}
\arguments{
\item{x}{A \code{caugi} object.}

\item{packing_ratio}{Aspect ratio for packing disconnected components
(width/height). Default is the golden ratio (1.618) which works well with
widescreen displays. Use \code{1.0} for square grid, \code{2.0} for wider layouts,
\code{0.5} for taller layouts, \code{Inf} for single row, or \code{0.0} for single column.}

\item{...}{Ignored. For future extensibility.}
}
\value{
A \code{data.frame} with columns \code{name}, \code{x}, and \code{y} containing node
names and their coordinates.
}
\description{
Computes node coordinates using the Fruchterman-Reingold force-directed
layout algorithm. Fast spring-electrical model that treats edges as springs
and nodes as electrically charged particles. Produces organic, symmetric
layouts with uniform edge lengths. Works with all edge types and produces
deterministic results.
}
\examples{
cg <- caugi(
  A \%-->\% B,
  B \%<->\% C,
  C \%-->\% D
)
layout <- caugi_layout_fruchterman_reingold(cg)

}
\seealso{
Other plotting: 
\code{\link{add-caugi_plot-caugi_plot}},
\code{\link{caugi_layout}()},
\code{\link{caugi_layout_bipartite}()},
\code{\link{caugi_layout_kamada_kawai}()},
\code{\link{caugi_layout_sugiyama}()},
\code{\link{caugi_layout_tiered}()},
\code{\link{caugi_plot}()},
\code{\link{divide-caugi_plot-caugi_plot}},
\code{\link{plot}()}
}
\concept{plotting}
