% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_codebook.R
\name{export_codebook}
\alias{export_codebook}
\title{Export Codebook to CSV or Excel}
\usage{
export_codebook(codebook, file_path, ...)
}
\arguments{
\item{codebook}{A codebook dataframe created with \code{create_codebook()}.}

\item{file_path}{The path where the file should be saved, including file extension.
Use .csv for CSV or .xlsx for Excel.}

\item{...}{Additional arguments passed to write functions.}
}
\value{
Invisibly returns the file path where the codebook was saved.
}
\description{
This function exports a CES codebook to a CSV or Excel file for easier viewing and sharing.
}
\examples{
\donttest{
# Get data and create codebook
ces_data <- get_ces("2019")
codebook <- create_codebook(ces_data)

# Export to CSV
export_codebook(codebook, "ces_2019_codebook.csv")

# Export to Excel
export_codebook(codebook, "ces_2019_codebook.xlsx")
}

}
