% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_bibentry.R
\name{as_bibentry}
\alias{as_bibentry}
\alias{as_bibentry.default}
\alias{as_bibentry.character}
\alias{as_bibentry.NULL}
\alias{as_bibentry.list}
\alias{as_bibentry.cff}
\alias{as_bibentry.cff_ref_lst}
\alias{as_bibentry.cff_ref}
\title{Create \code{\link{bibentry}} objects from several sources}
\usage{
as_bibentry(x, ...)

\method{as_bibentry}{default}(x, ...)

\method{as_bibentry}{character}(x, ..., what = c("preferred", "references", "all"))

\method{as_bibentry}{`NULL`}(x, ...)

\method{as_bibentry}{list}(x, ...)

\method{as_bibentry}{cff}(x, ..., what = c("preferred", "references", "all"))

\method{as_bibentry}{cff_ref_lst}(x, ...)

\method{as_bibentry}{cff_ref}(x, ...)
}
\arguments{
\item{x}{The source that would be used for generating
the \code{bibentry} object via \CRANpkg{cffr}. It could be:
\itemize{
\item A missing value. That would retrieve the \code{DESCRIPTION}
file on your in-development package.
\item An existing \code{cff} object created with \code{\link[=cff]{cff()}}, \code{\link[=cff_create]{cff_create()}} or
\code{\link[=as_cff]{as_cff()}}.
\item Path to a CITATION.cff file (\code{"CITATION.cff"}),
\item The name of an installed package (\code{"jsonlite"}), or
\item Path to a DESCRIPTION file (\code{"DESCRIPTION"}).
}}

\item{...}{Additional arguments to be passed to or from methods.}

\item{what}{Fields to extract from a full \code{cff} object. The value could be:
\itemize{
\item \code{preferred}: This would create a single entry with the main citation
info of the package (key \code{preferred-citation}).
\item \code{references}: Extract all the entries of \code{references} key.
\item \code{all}: A combination of the previous two options. This would extract
both the \code{preferred-citation} and the \code{references} key.
}

See \code{vignette("crosswalk", package = "cffr")}.}
}
\value{
\code{as_bibentry()} returns a \code{bibentry} object with one or more entries.
}
\description{
This function creates \code{\link{bibentry}} objects from different metadata sources
(\code{\link{cff}} objects, \code{DESCRIPTION} files, etc.). The inverse transformation
(\code{bibentry} object to \code{\link{cff_ref_lst}}) can be done with the corresponding
\code{\link[=as_cff.bibentry]{as_cff.bibentry()}} method.

With \code{\link[=toBibtex.cff]{toBibtex()}} it is possible to convert \code{cff} objects
to BibTeX markup on the fly, see \strong{Examples}.
}
\details{
A \strong{R} \code{bibentry} object is the representation of a BibTeX entry. These
objects can be converted to BibTeX markup with \code{\link[=toBibtex]{toBibtex()}}, that creates an
object of class \code{Bibtex} and can be printed and exported as a valid BibTeX
entry.

\code{as_bibtex()} tries to map the information of the source \code{x} into a \verb{cff] object and performs a mapping of the metadata to BibTeX, according to }vignette("bibtex_cff", "cffr")`.
}
\examples{
\donttest{
# From a cff object ----
cff_object <- cff()

cff_object

# bibentry object
bib <- as_bibentry(cff_object)

class(bib)

bib

# Print as bibtex
toBibtex(bib)

# Thanks to the S3 Method we can also do
toBibtex(cff_object)

# Other sources ----
# From a CITATION.cff

path <- system.file("examples/CITATION_complete.cff", package = "cffr")
cff_file <- as_bibentry(path)

cff_file

# For an installed package with options
installed_package <- as_bibentry("jsonvalidate", what = "all")

installed_package


# Use a DESCRIPTION file
path2 <- system.file("examples/DESCRIPTION_gitlab", package = "cffr")
desc_file <- as_bibentry(path2)

toBibtex(desc_file)
}

}
\references{
\itemize{
\item Patashnik, Oren. "BIBTEXTING" February 1988.
\url{https://osl.ugr.es/CTAN/biblio/bibtex/base/btxdoc.pdf}.
\item Haines, R., & The Ruby Citation File Format Developers. (2021).
\emph{Ruby CFF Library (Version 0.9.0)} (Computer software).
\doi{10.5281/zenodo.1184077}.
\item Hernangomez D (2022). "BibTeX and CFF, a potential crosswalk."
\emph{The cffr package, Vignettes}. \doi{10.21105/joss.03900},
\url{https://docs.ropensci.org/cffr/articles/bibtex-cff.html}.
}
}
\seealso{
\code{\link[utils:bibentry]{utils::bibentry()}} to understand more about the \code{bibentry} class.
\itemize{
\item \code{vignette("crosswalk", package = "cffr")} provides details on how the
metadata of a package is mapped to produce a \code{cff} object.
\item \code{vignette("bibtex_cff", "cffr")} provides detailed information about the
internal mapping performed between \code{cff} objects and BibTeX markup (
both \code{cff} to BibTeX and BibTeX to \code{cff}).
}

Other related functions:
\itemize{
\item \code{\link[utils:toLatex]{utils::toBibtex()}}.
}

Other functions for working with BibTeX format:
\code{\link{cff_read}()},
\code{\link{cff_read_bib_text}()},
\code{\link{cff_write_bib}()},
\code{\link{encoded_utf_to_latex}()}

Coercing between \strong{R} classes with \strong{S3 Methods}:
\code{\link{as_cff}()},
\code{\link{as_cff_person}()},
\code{\link{cff_class}}
}
\concept{bibtex}
\concept{s3method}
