% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createSpecifications4R.R
\name{createSpecifications4R}
\alias{createSpecifications4R}
\title{Create Specifications for R Function}
\usage{
createSpecifications4R(
  Model = "gpt-5-nano",
  SelectedCode = TRUE,
  verbose = TRUE,
  SlowTone = FALSE
)
}
\arguments{
\item{Model}{A character string specifying the GPT model to be used. Default is "gpt-5-nano".}

\item{SelectedCode}{A logical flag to indicate whether to read from RStudio's selected text. Default is TRUE.}

\item{verbose}{A logical value indicating whether to print the output. Default is TRUE.}

\item{SlowTone}{A logical value indicating whether to print the output slowly. Default is FALSE.}
}
\value{
The function prints the generated specifications to the console.
}
\description{
This function generates specifications for an R function from your selected text or clipboard.
   It takes in a text input, model name, verbosity, and tone speed to generate the specifications.
}
\details{
Create Specifications for R Function
}
\examples{
\dontrun{
# Option 1
# Select some text in RStudio and then run the rstudio addins
# Option 2
# Copy the text into your clipboard then execute
clipr::write_clip("A function which can compute the mean of a vector of any size")
createSpecifications4R(Model = "gpt-5-nano", SelectedCode = FALSE, verbose = TRUE, SlowTone = FALSE)
}


}
\author{
Satoshi Kume
}
