% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/container.R
\name{checkcli-containers}
\alias{checkcli-containers}
\alias{check_array_cli}
\alias{assert_array_cli}
\alias{check_matrix_cli}
\alias{assert_matrix_cli}
\alias{check_vector_cli}
\alias{assert_vector_cli}
\alias{check_list_cli}
\alias{assert_list_cli}
\alias{check_data_frame_cli}
\alias{assert_data_frame_cli}
\alias{check_factor_cli}
\alias{assert_factor_cli}
\alias{check_environment_cli}
\alias{assert_environment_cli}
\alias{check_function_cli}
\alias{assert_function_cli}
\alias{check_formula_cli}
\alias{assert_formula_cli}
\alias{check_r6_cli}
\alias{assert_r6_cli}
\alias{check_raw_cli}
\alias{assert_raw_cli}
\title{Container and data structure CLI assertions}
\usage{
check_array_cli(...)

assert_array_cli(x, ..., .var.name = checkmate::vname(x), add = NULL)

check_matrix_cli(...)

assert_matrix_cli(x, ..., .var.name = checkmate::vname(x), add = NULL)

check_vector_cli(...)

assert_vector_cli(x, ..., .var.name = checkmate::vname(x), add = NULL)

check_list_cli(...)

assert_list_cli(x, ..., .var.name = checkmate::vname(x), add = NULL)

check_data_frame_cli(...)

assert_data_frame_cli(x, ..., .var.name = checkmate::vname(x), add = NULL)

check_factor_cli(...)

assert_factor_cli(x, ..., .var.name = checkmate::vname(x), add = NULL)

check_environment_cli(...)

assert_environment_cli(x, ..., .var.name = checkmate::vname(x), add = NULL)

check_function_cli(...)

assert_function_cli(x, ..., .var.name = checkmate::vname(x), add = NULL)

check_formula_cli(...)

assert_formula_cli(x, ..., .var.name = checkmate::vname(x), add = NULL)

check_r6_cli(...)

assert_r6_cli(x, ..., .var.name = checkmate::vname(x), add = NULL)

check_raw_cli(...)

assert_raw_cli(x, ..., .var.name = checkmate::vname(x), add = NULL)
}
\arguments{
\item{...}{Additional arguments passed on to the corresponding
\pkg{checkmate} function (e.g. `lower`, `upper`, `any.missing`,
`all.missing`, `min.len`, `null.ok`).}

\item{x}{Object to be checked.
This is the value whose type, length, or other properties are validated.}

\item{.var.name}{Character scalar used in error messages to refer to
the checked object. Defaults to [checkmate::vname()], which tries to
infer the variable name from the calling context.}

\item{add}{Optional [checkmate::AssertCollection] to which
  assertion failures are added instead of triggering an immediate
  error. Defaults to `NULL`, which causes a `cli::cli_abort()` on
  failure.

- Generic containers:
  - [check_array_cli()], [assert_array_cli()] for multi-dimensional arrays.
  - [check_matrix_cli()], [assert_matrix_cli()] for 2D matrices.
  - [check_vector_cli()], [assert_vector_cli()] for (atomic or list) vectors.
  - [check_list_cli()], [assert_list_cli()] for lists.
  - [check_data_frame_cli()], [assert_data_frame_cli()] for data frames.
- Typed / special containers:
  - [check_factor_cli()], [assert_factor_cli()] for factor vectors.
  - [check_environment_cli()], [assert_environment_cli()] for environments.
  - [check_function_cli()], [assert_function_cli()] for functions.
  - [check_formula_cli()], [assert_formula_cli()] for formulas.
  - [check_r6_cli()], [assert_r6_cli()] for R6 objects.
  - [check_raw_cli()], [assert_raw_cli()] for raw vectors.

In all `assert_*_cli()` functions, `x` is the object being checked and
`.var.name` is used only for error message construction; the return value is
always `x` (invisibly) on success.}
}
\value{
- `check_*_cli()` functions return `TRUE` on success or a character vector
  describing the failure, exactly like the corresponding
  \pkg{checkmate} checks.
- `assert_*_cli()` functions return `x` invisibly on success and either:
  - raise a `cli::cli_abort()` error with bullet-style messages, or
  - push messages into an [checkmate::AssertCollection] if `add` is supplied.
}
\description{
These functions wrap container and structural checks from \pkg{checkmate} and
either return the underlying check result (`check_*_cli()`) or raise a
`cli::cli_abort()` error via [make_assertion()] (`assert_*_cli()`).
They target common R data structures such as arrays, matrices, generic
vectors, lists, data frames, factors, environments, functions, formulas, R6
objects, and raw vectors, while emitting consistent CLI-styled error
messages.
}
\examples{

# Arrays and matrices:

# 3D array (e.g. raster stack, simulation outputs)
arr <- array(1:12, dim = c(2, 2, 3))
check_array_cli(arr)
try(check_array_cli(list(1, 2, 3)))               # failure: not an array

assert_array_cli(arr)
try(assert_array_cli(list(1, 2, 3)))         # cli-styled error

# Simple 2x2 matrix
mat <- matrix(1:4, nrow = 2)
check_matrix_cli(mat)
try(check_matrix_cli(1:4))                        # failure: not a matrix

assert_matrix_cli(mat)
try(assert_matrix_cli(1:4))

# Vectors, lists, and data frames:

# Generic vector (atomic or list)
v <- 1:5
check_vector_cli(v)
try(check_vector_cli(mean))                       # failure: function, not vector

assert_vector_cli(v)
try(assert_vector_cli(mean))

# Lists
lst <- list(a = 1, b = 2)
check_list_cli(lst)
try(check_list_cli(1:3))                          # failure: atomic, not list

assert_list_cli(lst)
try(assert_list_cli(1:3))

# Data frames (e.g. species-by-site table)
df <- data.frame(x = 1:3, y = c("a", "b", "c"))
check_data_frame_cli(df)
try(check_data_frame_cli(list(x = 1:3)))          # failure

assert_data_frame_cli(df)
try(assert_data_frame_cli(list(x = 1:3)))

# Factors:

f <- factor(c("forest", "savanna", "forest"))
check_factor_cli(f)
try(check_factor_cli(c("forest", "savanna")))     # failure: not a factor

assert_factor_cli(f)
try(assert_factor_cli(c("forest", "savanna")))

# Environments and functions:

env <- new.env()
env$x <- 1
check_environment_cli(env)
try(check_environment_cli(list(x = 1)))          # failure

assert_environment_cli(env)
try(assert_environment_cli(list(x = 1)))

fun <- function(x) x * 2
check_function_cli(fun)
try(check_function_cli(1:3))                     # failure

assert_function_cli(fun)
try(assert_function_cli(1:3))

# Formulas:

fo <- abundance ~ temperature + precipitation
check_formula_cli(fo)
try(check_formula_cli("abundance ~ temperature")) # failure

assert_formula_cli(fo)
try(assert_formula_cli("abundance ~ temperature"))

# R6 objects:

if (requireNamespace("R6", quietly = TRUE)) {
  Model <- R6::R6Class("Model", public = list(fit = function(x) x))
  m <- Model$new()

  check_r6_cli(m)
  try(check_r6_cli(list()))                      # failure

  assert_r6_cli(m)
  try(assert_r6_cli(list()))
}

# Raw vectors:

r <- charToRaw("abc")
check_raw_cli(r)
try(check_raw_cli(c(1L, 2L)))                    # failure

assert_raw_cli(r)
try(assert_raw_cli(c(1L, 2L)))

}
\seealso{
[checkmate::check_array()], [checkmate::check_matrix()],
  [checkmate::check_vector()], [checkmate::check_list()],
  [checkmate::check_data_frame()], [checkmate::check_factor()],
  [checkmate::check_environment()], [checkmate::check_function()],
  [checkmate::check_formula()], [checkmate::check_raw()],
  [checkmate::check_r6()], [make_assertion()], [assert_cli()]

Other checkCLI: 
\code{\link{checkcli-datetime-os}},
\code{\link{checkcli-files}},
\code{\link{checkcli-names-sets}},
\code{\link{checkcli-scalars}}
}
\concept{checkCLI}
