% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_ci_diff.R
\name{ci_prop_diff_nc}
\alias{ci_prop_diff_nc}
\title{Newcombe Confidence Interval for Difference in Proportions}
\usage{
ci_prop_diff_nc(x, by, conf.level = 0.95, correct = FALSE, data = NULL)
}
\arguments{
\item{x}{(\code{binary}/\code{numeric}/\code{logical})\cr
vector of a binary values, i.e. a logical vector, or numeric with values \code{c(0, 1)}}

\item{by}{(\code{string}) \cr A character or factor vector with exactly two unique levels
identifying the two groups to compare. Can also be a column name if a data
frame provided in the \code{data} argument.}

\item{conf.level}{(\verb{scalar numeric}) \cr a scalar in (0,1) indicating the confidence level. Default is 0.95}

\item{correct}{(\code{logical})\cr apply continuity correction.}

\item{data}{(\code{data.frame}) \cr Optional data frame containing the variables specified in \code{x} and \code{by}.}
}
\value{
An object containing the following components:

\item{n}{The number of responses for each group}
\item{N}{The total number in each group}
\item{estimate}{The point estimate of the difference in proportions}
\item{conf.low}{Lower bound of the confidence interval}
\item{conf.high}{Upper bound of the confidence interval}
\item{conf.level}{The confidence level used}
\item{method}{Anderson-Hauck Confidence Interval}
}
\description{
Newcombe Confidence Interval for Difference in Proportions
}
\details{
The \strong{Wilson (Score)} confidence limits without continuity correction for each
individual binomial proportion, \eqn{p_i = x_i / n_i}, for \eqn{i = 1, 2}, are given by:

\deqn{
\frac{
  (2 n_i \hat{p}_i + z^2)
  \pm
  z \sqrt{ 4 n_i \hat{p}_i (1 - \hat{p}_i) + z^2 }
}{
  2 (n_i + z^2)
}
}

Denote the lower and upper Wilson (Score) confidence limits for \eqn{p_i} as
\eqn{L_i} and \eqn{U_i}, respectively.

Then, the \strong{Newcombe (Score)} confidence limits for the difference in proportions
(\eqn{p_1 - p_2}) are given by:

\deqn{
\text{Lower limit: } (\hat{p}_1 - \hat{p}_2) -
\sqrt{ (\hat{p}_1 - L_1)^2 + (U_2 - \hat{p}_2)^2 }
}

\deqn{
\text{Upper limit: } (\hat{p}_1 - \hat{p}_2) +
\sqrt{ (U_1 - \hat{p}_1)^2 + (\hat{p}_2 - L_2)^2 }
}

The confidence intervals with continuity correction for each individual binomial proportion are
obtained using the \strong{Wilson (Score) confidence limits with continuity correction}.

For each binomial proportion \eqn{p_i = x_i / n_i}, where \eqn{i = 1, 2},
the confidence intervals are given by:

\deqn{
\frac{ 2 n_i \hat{p}_i + z^2 }{ 2 (n_i + z^2) }
\; \pm \;
\frac{ z }{ 2 (n_i + z^2) }
\sqrt{
  z^2 - \frac{2}{n_i} + 4 \hat{p}_i
  \left[ n_i (1 - \hat{p}_i) + 1 \right]
}
}
}
\examples{
responses <- expand(c(9, 3), c(10, 10))
arm <- rep(c("treat", "control"), times = c(10, 10))

# Calculate 95\% confidence interval for difference in proportions
ci_prop_diff_nc(x = responses, by = arm)
}
\references{
Newcombe, R. G. (1998). Interval estimation for the difference between
independent proportions: Comparison of eleven methods. \emph{Statistics in Medicine, 17}(8), 873–890.
\href{https://www.lexjansen.com/wuss/2016/127_Final_Paper_PDF.pdf}{Constructing Confidence Intervals for the Differences of Binomial Proportions in SAS}
}
