% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_date.R
\name{to_date}
\alias{to_date}
\title{Convert numerical or character date to date.}
\usage{
to_date(
  x,
  from_excel = TRUE,
  verbose = TRUE,
  try_formats = c("\%Y-\%m-\%d", "\%Y/\%m/\%d", "\%Y\%m\%d", "\%Y.\%m.\%d")
)
}
\arguments{
\item{x}{A vector that stores dates in numerical or character types.}

\item{from_excel}{If TRUE, treat numerical values as Excel dates.}

\item{verbose}{If TRUE, print the values that cannot be converted.}

\item{try_formats}{A character vector of date formats to try. Same as \code{tryFormats} in \code{as.Date}.}
}
\value{
A single valid value from the vector. \code{NA} if all values are invalid.
}
\description{
Convert numerical (especially Excel date) or character date to date. Can deal with
common formats and allow different formats in one vector.
}
\examples{
to_date(c(43562, "2020-01-01", "2020/01/01", "20200101", "2020.01.01"))
}
