\name{bars_agitation_score}
\alias{bars_agitation_score}
\title{
Behavioral Activity Rating Scale (BARS)
}
\description{
Retrieves the description and clinical status for a given Behavioral Activity Rating Scale (BARS) score. BARS is a validated tool used to assess the severity of agitation in patients, particularly in acute psychiatric or emergency settings. It utilizes a 7-point scale ranging from 1 (Difficult to rouse) to 7 (Violent).
}
\usage{
bars_agitation_score(patient_state_score)
}
\arguments{
  \item{patient_state_score}{
Numeric (1-7). The observed state of the patient.
1: Difficult or unable to rouse.
2: Asleep but responds normally to verbal or physical contact.
3: Drowsy, appears sedated.
4: Quiet and awake (normal level of activity).
5: Signs of overt (physical or verbal) activity, calms down with instructions.
6: Extremely or continuously active, not requiring restraint.
7: Violent, requires restraint.
}
}
\value{
A list containing:
\item{BARS_Score}{The input score.}
\item{Description}{The specific behavioral description associated with the score.}
\item{Clinical_Status}{General categorization (e.g., Sedated, Normal, Agitated).}
}
\references{
Swift RH, Harrigan EP, Cappelleri JC, et al. Validation of the Behavioural Activity Rating Scale (BARS): a novel measure of activity in agitated patients. J Psychiatr Res. 2002;36(2):87-95. doi:10.1016/s0022-3956(01)00053-6
}
\examples{

# Example 1: Normal Activity
bars_agitation_score(4)

# Example 2: Severe Agitation
bars_agitation_score(7)
}
