\name{cpot_pain_score}
\alias{cpot_pain_score}
\title{
Critical Care Pain Observation Tool (CPOT)
}
\description{
Calculates the CPOT score, a behavioral pain assessment tool for critically ill adults who cannot self-report (e.g., sedated or intubated patients). The scale evaluates four domains: Facial Expression, Body Movements, Muscle Tension, and Compliance with Ventilator (or Vocalization for non-intubated patients). A score greater than 2 indicates significant pain.
}
\usage{
cpot_pain_score(facial_expression, body_movements, muscle_tension,
                compliance_or_vocalization)
}
\arguments{
  \item{facial_expression}{
Numeric (0-2).
0: Relaxed/Neutral.
1: Tense (Frowning, brow lowering).
2: Grimacing (Tight eyelids).
}
  \item{body_movements}{
Numeric (0-2).
0: Absence of movements.
1: Protection (Slow, cautious movements, touching painful site).
2: Restlessness (Thrashing, pulling at tubes).
}
  \item{muscle_tension}{
Numeric (0-2). Assessed by passive flexion/extension of the arm.
0: Relaxed.
1: Tense/Rigid (Resistance to passive movement).
2: Very Tense/Rigid (Strong resistance).
}
  \item{compliance_or_vocalization}{
Numeric (0-2).
If Intubated:
0: Tolerating ventilator (No alarms).
1: Coughing but tolerating (Alarms stop spontaneously).
2: Fighting ventilator (Asynchrony).
If Extubated:
0: Normal talk/No sound.
1: Sighing/Moaning.
2: Crying/Sobbing.
}
}
\value{
A list containing:
\item{CPOT_Score}{The calculated total score (Range 0-8).}
\item{Interpretation}{Clinical guidance ("Positive for Pain" if Score > 2).}
}
\references{
Gélinas C, Fillion L, Puntillo KA, Viens C, Fortier M. Validation of the critical-care pain observation tool in adult patients. Am J Crit Care. 2006;15(4):420-427.
}
\examples{

# Example 1: Significant Pain
# Grimacing (2), Restless (2), Tense (1), Fighting vent (2)
# Score = 7
cpot_pain_score(2, 2, 1, 2)

# Example 2: No Pain
# Relaxed (0), No movement (0), Relaxed muscles (0), Tolerating vent (0)
# Score = 0
cpot_pain_score(0, 0, 0, 0)
}
