\name{impede_vte_score}
\alias{impede_vte_score}
\title{
IMPEDE VTE Score for Multiple Myeloma
}
\description{
Calculates the IMPEDE VTE score to predict the 6-month risk of venous thromboembolism in patients with Multiple Myeloma. This tool stratifies patients into Low, Intermediate, and High risk categories, incorporating both risk factors (e.g., IMiDs, history of VTE) and protective factors (e.g., infection, low BMI).
}
\usage{
impede_vte_score(infection, bmi_lt_25, steroid_use, pe_history, dvt_history,
                 erythropoietin_agent, doxorubicin_regimen,
                 existing_central_catheter, thalidomide_analog,
                 enzalutamide_abiraterone)
}
\arguments{
  \item{infection}{
Numeric (0 or 1). Serious infection (requiring hospitalization) within prior 3 months. (1 = Yes, -3 points).
}
  \item{bmi_lt_25}{
Numeric (0 or 1). Body Mass Index < 25 kg/m^2. (1 = Yes, -1 point).
}
  \item{steroid_use}{
Numeric (0 or 1). Use of Dexamethasone or Prednisone. (1 = Yes, +1 point).
}
  \item{pe_history}{
Numeric (0 or 1). History of Pulmonary Embolism. (1 = Yes, +3 points).
}
  \item{dvt_history}{
Numeric (0 or 1). History of Deep Vein Thrombosis. (1 = Yes, +2 points).
}
  \item{erythropoietin_agent}{
Numeric (0 or 1). Use of Erythropoiesis-Stimulating Agents. (1 = Yes, +3 points).
}
  \item{doxorubicin_regimen}{
Numeric (0 or 1). Use of Doxorubicin or Pegylated Doxorubicin. (1 = Yes, +2 points).
}
  \item{existing_central_catheter}{
Numeric (0 or 1). Presence of existing Central Venous Catheter or PICC. (1 = Yes, +3 points).
}
  \item{thalidomide_analog}{
Numeric (0 or 1). Use of Thalidomide, Lenalidomide, or Pomalidomide (IMiDs). (1 = Yes, +3 points).
}
  \item{enzalutamide_abiraterone}{
Numeric (0 or 1). Note: While the tool includes this variable for general context or future adaptation, in standard IMPEDE for MM, this specific variable might not be part of the core 9-factor derivation in all versions, but it is often included in broader oncologic VTE models. For strict IMPEDE MM calculation, verify if this is a core component or an addition. MDCalc includes 10 items. Assuming +3 points based on typical high-risk medication weighting if included.
}
}
\value{
A list containing:
\item{IMPEDE_Score}{The calculated total score.}
\item{Risk_Category}{Classification (Low <= 1, Intermediate 2-5, High >= 6).}
\item{Six_Month_VTE_Risk}{Estimated percentage risk of VTE at 6 months.}
}
\references{
Sanfilippo KM, Luo S, Wang TF, et al. Predicting Venous Thromboembolism in Multiple Myeloma: Development and Validation of the IMPEDE VTE Score. Am J Hematol. 2019;94(11):1176-1184. doi:10.1002/ajh.25603
}
\examples{

# Example 1: High Risk
# Hx PE (+3), IMiD (+3), Steroids (+1)
# Score = 7
impede_vte_score(0, 0, 1, 1, 0, 0, 0, 0, 1, 0)

# Example 2: Low Risk
# Low BMI (-1), Recent Infection (-3), Steroids (+1)
# Score = -3
impede_vte_score(1, 1, 1, 0, 0, 0, 0, 0, 0, 0)
}
