\name{maintenance_fluids_dosing}
\alias{maintenance_fluids_dosing}
\title{
Maintenance Fluids Calculator (4-2-1 Rule)
}
\description{
Calculates the maintenance fluid requirement for pediatric and adult patients using the Holliday-Segar (4-2-1) rule. This method estimates the hourly IV fluid rate required to maintain hydration based on body weight.
}
\usage{
maintenance_fluids_dosing(weight_kg)
}
\arguments{
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
}
\details{
The 4-2-1 Rule calculates the hourly rate as follows:
\itemize{
  \item First 10 kg: 4 mL/kg/hr
  \item Next 10 kg (11-20 kg): 2 mL/kg/hr
  \item Each kg above 20 kg: 1 mL/kg/hr
}
}
\value{
A list containing:
\item{Hourly_Rate_mL_hr}{The calculated maintenance rate in mL per hour.}
\item{Daily_Volume_mL_day}{The total fluid volume required over 24 hours.}
}
\references{
Holliday MA, Segar WE. The maintenance need for water in parenteral fluid therapy. Pediatrics. 1957;19(5):823-832.
}
\examples{

# Example 1: Adult (70 kg)
# 40 + 20 + 50 = 110 mL/hr
maintenance_fluids_dosing(70)

# Example 2: Child (15 kg)
# 40 + (5 * 2) = 50 mL/hr
maintenance_fluids_dosing(15)
}
