\name{modified_fisher_grade}
\alias{modified_fisher_grade}
\title{
Modified Fisher Grading Scale for Subarachnoid Hemorrhage
}
\description{
Calculates the Modified Fisher Grade, an updated radiographic scale for predicting the risk of delayed cerebral ischemia (vasospasm) following subarachnoid hemorrhage. Unlike the original Fisher scale, this version specifically accounts for the presence of intraventricular hemorrhage (IVH) and thick cisternal blood separately.
}
\usage{
modified_fisher_grade(sah_present, ich_ivh_present, clot_thickness_ge_1mm)
}
\arguments{
  \item{sah_present}{
Numeric (0 or 1). Is subarachnoid hemorrhage present? (1 = Yes).
}
  \item{ich_ivh_present}{
Numeric (0 or 1). Is intraventricular hemorrhage (IVH) present? (1 = Yes).
}
  \item{clot_thickness_ge_1mm}{
Numeric (0 or 1). Is the SAH clot thick (>= 1 mm)? (1 = Yes).
}
}
\value{
A list containing:
\item{Modified_Fisher_Grade}{The calculated grade (0-4).}
\item{CT_Findings}{Description of the radiographic pattern.}
\item{Symptomatic_Vasospasm_Risk}{Estimated risk percentage.}
}
\references{
Claassen J, Bernardini GL, Kreiter K, et al. Effect of cisternal and ventricular blood on risk of delayed cerebral ischemia after subarachnoid hemorrhage: the Fisher scale revisited. Stroke. 2001;32(9):2012-2020. doi:10.1161/hs0901.095677
}
\examples{

# Example 1: Highest Risk (Grade 4)
# Thick SAH (1), IVH (1)
modified_fisher_grade(1, 1, 1)

# Example 2: Intermediate Risk (Grade 2)
# Thin SAH (0), IVH (1)
modified_fisher_grade(1, 1, 0)
}
