\name{nccn_ipi_score}
\alias{nccn_ipi_score}
\title{
NCCN-IPI for Diffuse Large B-Cell Lymphoma
}
\description{
Calculates the NCCN-IPI score to predict 5-year overall survival in patients with Diffuse Large B-Cell Lymphoma (DLBCL) treated with rituximab-based chemotherapy. This enhanced index refines the original IPI by better stratifying age and LDH levels and identifying specific high-risk extranodal sites.
}
\usage{
nccn_ipi_score(age, ldh_ratio, extranodal_sites_disease, stage,
               performance_status)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
<= 40: 0 pts.
41-60: 1 pt.
61-75: 2 pts.
> 75: 3 pts.
}
  \item{ldh_ratio}{
Numeric. Ratio of patient's LDH to the Upper Limit of Normal (ULN).
<= 1: 0 pts.
> 1-3: 1 pt.
> 3: 2 pts.
}
  \item{extranodal_sites_disease}{
String. Presence of disease in specific high-risk extranodal sites (Bone Marrow, CNS, Liver, GI Tract, or Lung).
"bone_marrow", "cns", "liver", "gi_tract", "lung": 1 pt.
"none_or_other": 0 pts.
}
  \item{stage}{
Numeric. Ann Arbor Stage (1-4).
Stage III or IV: 1 pt.
Stage I or II: 0 pts.
}
  \item{performance_status}{
Numeric. ECOG Performance Status (0-4).
>= 2: 1 pt.
< 2: 0 pts.
}
}
\value{
A list containing:
\item{NCCN_IPI_Score}{The calculated total score (Range 0-8).}
\item{Risk_Group}{Classification (Low, Low-Intermediate, High-Intermediate, High).}
\item{Est_5_Year_Overall_Survival}{Estimated 5-year overall survival percentage.}
}
\references{
Zhou Z, Sehn LH, Rademaker AW, et al. An enhanced International Prognostic Index (NCCN-IPI) for patients with diffuse large B-cell lymphoma treated in the rituximab era. Blood. 2014;123(6):837-842. doi:10.1182/blood-2013-09-524108
}
\examples{

# Example 1: High Risk
# Age 80 (+3), LDH 4x (+2), Bone Marrow (+1), Stage IV (+1), ECOG 2 (+1)
# Score = 8
nccn_ipi_score(80, 4.0, "bone_marrow", 4, 2)

# Example 2: Low Risk
# Age 35 (0), Normal LDH (0), No high-risk sites, Stage I (0), ECOG 0 (0)
# Score = 0
nccn_ipi_score(35, 0.8, "none_or_other", 1, 0)
}
